<?php namespace Modules\Cart\Models;

use DB;
use stdClass;
use App\Models\Model;
use Modules\Book\Models\Book;
use App;

class Cart extends Model
{
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'xxcart';

    /**
     * The primary key for the model.
     *
     * @var string
     */
    protected $primaryKey = 'xcartid';

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;

    protected $guarded = ['xcartid'];

    protected $casts = [
        'xrank' => 'int',
    ];

    /**
     * Get the book for the cart.
     */
    public function books()
    {
       return $this->hasMany(Book::class,'xcartid');
    }

    /**
     * get Result
     * @param $query
     * @return mixed
     */
    public static function getResult()
    {
        $instance = new static();

        $res = DB::table("$instance->table AS p1")
            ->leftJoin('xxcart AS p2','p1.xparentid','=','p2.xcartid')
            ->select(['p1.*', "p1.{$instance->primaryKey} AS xid","p2.xcart_title AS xparent_title"]);

        return $res;
    }

    public static function updateById($data,$id=0)
    {
        $instance = new static();
        return $instance->updateOrCreate([$instance->primaryKey => $id],$data);
    }

    /**
     * delete
     * @param $id
     * @return mixed
     */
    public static function remove($id)
    {
        $instance = new static();

        if ($id){
            $res = $instance->destroy($id);
            parent::deleteFile($id);
            die('[[OK]]'); 
        }
        else
            die('[[Error]]');
        return $res;
    }
}