<?php
namespace Modules\Cart\Http\Controllers\Index;

use App\Http\Controllers\IndexController;
use Auth;
use Cart;
use Input;
use Modules\Book\Models\Book;
use Modules\Home\Models\Province;
use Modules\Goldiran\Traits\GS;
use Modules\Home\Traits\Location;

class ShippingController extends IndexController {
    use GS,Location;
    /**
     * Show the application cart to the user.
     *
     * @return Response
     */
    public function index($id, $title = '') {
        if (!auth()->id()) {
            return redirect(getCurrentURL('locale') . '/User/login')->with(['previous' => '/Shipping']);
        }

        if (!Cart::count()) {
            return redirect(getCurrentURL('locale') . '/Home');
        }

        $address = Auth::user()->address()->orderBy('update_at', 'desc')->get();
        if ($address->count() > 0) {
            Cart::setAddress($address->first()->xaddressid);
        }

        $location = self::getZones();


        $title = t("shipping");
        //$breadcrumb[] = ['title' => $title, 'href' => ''];
        //$this->layout->breadcrumb = $breadcrumb;
        $this->layout->title = $title;
        $this->layout->content = view('cart::index.shipping', array_merge([
            'address' => $address, 
        ],$location));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function store() {
        $id = Input::get('id');
        $type = Input::get('type', 'book');

        $class = config("cart.classes.{$type}.namespace", Book::class);
        $title = config("cart.classes.{$type}.title", 'xbook_title');
        $price = config("cart.classes.{$type}.price", 'xbook_hard_price');
        $discount = config("cart.classes.{$type}.discount", 'xbook_hard_discount');
        $relOptions = config("cart.classes.{$type}.relationOptions", null);
        $options = config("cart.classes.{$type}.options", null);

        $product = $class::findWith($id);

        if ($product && $product->count() > 0) {
            $optionList = [];
            if ($options) {
                foreach ($options as $key => $value) {
                    $optionList[$key] = $product->$value;
                }
            }

            if ($relOptions) {
                foreach (@$relOptions as $key => $value) {
                    $optionList[$key] = $product->$key->$value;
                }
            }

            Cart::add($id, $product->$title, 1, $product->$price ?: 0, $product->$discount ?: 0, $optionList)
                ->associate($class);

            return response()->json(['success' => true]);
        }
        die(json_encode(t("product not find.")));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update() {
        $data = Input::get('data');

        if (!@$data['mobile'] or !@$data['address'] or !@$data['title'] or !@$data['name'] or !@$data['province'] or !@$data['postalCode']) {
            return response()->json(['success' => false, 'msg' => 'وارد کردن اطلاعات فیلدها ضروری است'], 404);
        }
        $user = Auth::user();
        if ($user) {
            if ($data['id']) {
                $address = $user->address()->find($data['id']);
                $address->xaddress_title = @$data['title'] ?: 'عنوان جدید';
                $address->xaddress_phone = $data['mobile'];
                $address->xaddress_content = $data['address'];
                $address->xaddress_name = $data['name'];
                $address->xprovinceid = $data['province'];
                $address->xcityid = @$data['city'];
                $address->xregionid = @$data['region'];
                $address->xparishid = @$data['parish'];
                $address->xaddress_postal_code = $data['postalCode'];
                $address->save();

            } else {
                $address = $user->address()->create([
                    'xaddress_title' => @$data['title'] ?: 'عنوان جدید',
                    'xaddress_phone' => $data['mobile'],
                    'xaddress_content' => $data['address'],
                    'xaddress_name' => $data['name'],
                    'xprovinceid' => $data['province'],
                    'xcityid' => @$data['city'],
                    'xregionid' => @$data['region'],
                    'xparishid' => @$data['parish'],
                    'xaddress_postal_code' => $data['postalCode'],
                ]);
            }

            Cart::setAddress($address->xaddressid);

            return response()->json([
                'id' => $address->xaddressid,
                'title' => $address->xaddress_title,
                'mobile' => $address->xaddress_phone,
                'address' => $address->xaddress_content,
                'name' => $address->xaddress_name,
                'province' => $address->xprovinceid,
                'city' => $address->xcityid,
                'region' => $address->xregionid,
                'parish' => $address->xparishid,
                'postalCode' => $address->xaddress_postal_code,
            ]);

        }
        return response()->json(['success' => false, 'msg' => 'خطا در برقراری ارتباط'], 404);
    }

    public function change() {
        $id = Input::get('id');
        $user = Auth::user();

        if ($user) {
            $address = $user->address()->find($id);
            if ($address) {
                Cart::setAddress($id);
                return response()->json([
                    'title' => $address->xaddress_title,
                    'mobile' => $address->xaddress_phone,
                    'address' => $address->xaddress_content,
                    'name' => $address->xaddress_name,
                    'province' => $address->xprovinceid,
                    'postalCode' => $address->xaddress_postal_code,
                ]);
            }

        }
        return response()->json(['success' => false], 404);
    }

    public function changePostMethod() {
        $postMethod = Input::get('postMethod') == 'bikePost' ? 'bikePost' : 'normalPost';
        Cart::setPostMethod($postMethod);

        return response()->json(Cart::totalAll());
    }

}
