<?php

namespace Modules\Cart\Http\Controllers\Index;

ignore_user_abort(true);

use App;
use App\Http\Controllers\IndexController;
use Auth;
use Bank;
use Cart;
use Illuminate\Support\Carbon;
use Input;
use Modules\Account\Models\Agent;
use Modules\Account\Models\Session;
use Modules\Account\Models\User;
use Modules\Book\Models\Book;
use Modules\Book\Models\BookCode;
use Modules\Shop\Models\Product;
use Modules\Cart\Entities\CartItem;
use Modules\Cart\Models\Address;
use Modules\Cart\Models\Copoun;
use Modules\Cart\Models\Invoice;
use Modules\Cart\Traits\Discount;
use Illuminate\Support\Facades\Http;
use Redirect;
use SoapClient;
use Modules\Goldiran\Traits\GS;

class PaymentController extends IndexController
{
    use Discount, GS;

    private $books;
    private $quantity;
    /**
     * Show the application cart to the user.
     *
     * @return Response
     */
    public function index($id, $title = '')
    {
        $user = Auth::user();
        if (!$user) {
            return redirect(getCurrentURL('locale') . '/User/login')->with(['previous' => '/Payment']);
        }
        $userInfo = Input::get('userInfo');
        $paymentType = Input::get('payment');
        $bank = Input::get('bank');
        $postMethod = Input::get('post');
        $postMethod = $postMethod ? 'bikePost' : 'normalPost';

        if ($userInfo) {
            $userInfo = json_decode($userInfo, true);
            if ($userInfo['name']) $user->userInfo->xname = $userInfo['name'];
            if ($userInfo['family']) $user->userInfo->xfamily = $userInfo['family'];
            if ($userInfo['intcode']) $user->userInfo->xintcode = $userInfo['intcode'];
            $user->userInfo->save();
        }
        if (Cart::getPostMethod() == 'unknown') {
            Cart::setPostMethod($postMethod);
        }

        if ($paymentType) Cart::setPaymentMethod($paymentType);
        if ($bank) Cart::setBank($bank);

        $address = $user->address()->find(Cart::getAddress());

        $title = t("preview");
        //$breadcrumb[] = ['title' => $title, 'href' => ''];
        //$this->layout->breadcrumb = $breadcrumb;
        $this->layout->title2 = t($title);
        $this->layout->content = view('cart::index.previewCart', ['address' => $address]);
    }

    public function digitalCode()
    {
        $code = Input::get('code');
        $session = Input::get('session');
        $user = Input::get('user');
        

        if (!$code || !$code['UserName']) {
            return back()->withErrors(['اطلاعات به درستی وارد نشده است']);
        }

        $serviceUrl = 'http://hscodeing.ir/api/WebServiceBook';
        try {
            $curl = curl_init();

            curl_setopt_array($curl, array(
                CURLOPT_URL => $serviceUrl,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_ENCODING => "",
                CURLOPT_MAXREDIRS => 10,
                CURLOPT_TIMEOUT => 30,
                CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                CURLOPT_CUSTOMREQUEST => "GET",
                CURLOPT_HTTPHEADER => array(
                    "cache-control: no-cache",
                    "username: {$code['UserName']}",
                    "userpassword: {$code['Password']}"
                ),
            ));

            $response = json_decode(curl_exec($curl), true);

            if ($response !== false && $response['Status'] == 1) {
                BookCode::updateById([
                    'xuserid' => $user,
                    'xdeviceid' => 1,
                    'xbookid' => 1297,
                    'xcode' => $code['UserName'],
                    'ximei' => $session,
                    'xmac' => $session,
                ]);
                die('اطلاعات شما با موفقیت در سیستم ثبت شد. جهت دریافت کتاب به اپلیکیشن مراجعه نمائید.');
            } else {
                die('شما حق دسترسی به این کتاب را ندارید. جهت اطلاعات بیشتر با واحد پشتیبانی تماس حاصل نمائید');
            }
        } catch (\Throwable $th) {
            return Redirect::back()->withErrors(['msg', 'عدم اتصال به سامانه تحلیل داده شرکت چاپ و نشر']);
        }

        // $serviceUrl = 'http://TabrizSoftware.com/cppc98/LockWebService.asmx?WSDL';
        // try {
        //     $soap = new SoapClient($serviceUrl);
        //     $result = $soap->Check_UserName_Valid(['UserName' => $code['UserName']]);
        // } catch (\SoapFault $e) {
        //     die($e);
        // }
        // if ($result->Check_UserName_ValidResult) {
        //     try {
        //         $soap = new SoapClient($serviceUrl);
        //         $result = $soap->Check_Information(['UserName' => $code['UserName']]);
        //     } catch (\SoapFault $e) {
        //         die($e);
        //     }
        //     if ($result->Check_InformationResult) {

        //     } else {

        //     }
        //     try {
        //         $code['Bios_Characterstics'] = $code['Bios_Caption'] = $code['BaseBoard_ProductName'] = $session;
        //         $soap = new SoapClient($serviceUrl);
        //         $result = $soap->Get_Activation_Code($code);
        //     } catch (\SoapFault $e) {
        //         die($e);
        //     }

        //     if (strtolower($result->Get_Activation_CodeResult) == strtolower(md5($session))) {
        //         BookCode::updateById([
        //             'xuserid' => $user,
        //             'xdeviceid' => 1,
        //             'xbookid' => 1221,
        //             'xcode' => $code['UserName'],
        //             'ximei' => $session,
        //             'xmac' => $session,
        //         ]);
        //         die('اطلاعات شما با موفقیت در سیستم ثبت شد. جهت دریافت کتاب به اپلیکیشن مراجعه نمائید.');
        //     } else {
        //         die('شما حق دسترسی به این کتاب را ندارید. جهت اطلاعات بیشتر با واحد پشتیبانی تماس حاصل نمائید');
        //     }
        // } else {
        //     return Redirect::back()->withErrors(['msg', 'کد اشتباه است']);
        // }

    }

    public function digitalindex()
    {
        $bookid = Input::get('id');
        $session = Input::get('session');

        if ($session) {
            $dbSession = Session::where('xuuid', $session)->first();
            if ($dbSession) {
                $user = User::find($dbSession->xuserid);
                if ($user) {
                    $isBookBoughted = $this->isUserBoughtedDigitalBook($user, $bookid);
                    if ($isBookBoughted) {
                        die('کتاب از قبل خریداری شده است.');
                    } else {
                        if ((int) $bookid == 1221 || (int) $bookid == 1297) {
                            $this->layout = view('account::index.auth.layout', array('title' => $this->title));
                            $this->layout->title2 = t("preview");
                            $this->layout->content = view('cart::index.bookCode', ['user' => $user->xuserid, 'session' => $session]);
                        } else {
                            Cart::destroy();
                            $res = app('Modules\Cart\Http\Controllers\Index\CartController')->addToCart($bookid, 'book');
                            Cart::setPaymentMethod('digitalPayment');
                            $this->layout = view('account::index.auth.layout', array('title' => $this->title));
                            $this->layout->title2 = t("preview");
                            $this->layout->content = view('cart::index.previewCart', ['user' => $user->xuserid]);
                        }
                    }
                } else {
                    die('. کاربر مورد نظر یافت نشد. لطفا وارد سیستم شوید');
                }
            } else {
                die('خطا در پردازش اطلاعات جلسه. لطفا دوباره تلاش نمائید...');
            }
        } else {
            die('خطا در پردازش اطلاعات جلسه. لطفا دوباره تلاش نمائید...');
        }
    }

    private function isUserBoughtedDigitalBook($user, $bookid)
    {
        $isBookBoughted = false;
        if ((int) $bookid == 1221) {
            $isBookBoughted = BookCode::where('xbookid', 1221)->where('xuserid', $user->xuserid)->count();
        } else if ((int) $bookid == 1297) {
            $isBookBoughted = BookCode::where('xbookid', 1297)->where('xuserid', $user->xuserid)->count();
        } else {
            foreach ($user->invoices()->with('books')->where('xinvoice_ship', 'digital') as $invoice) {
                $isBookBoughted = $invoice->books->search(function ($item) use ($bookid) {
                    return $item->xbookid == $bookid;
                });
                if ($isBookBoughted) {
                    break;
                }
            }
        }

        return $isBookBoughted;
    }

    private function initialPayment($invoiceStatus, $isDigital = false)
    {
        $user = Auth::user();
        $totalDiscount = $this->checkDiscount();
        $total = $totalDiscount['subtotal'];
        $postPrice = 0;
        $postMethod = '';

        if (!$isDigital) {
            try {
                $addressId = Cart::getAddress();
                $postMethod = Cart::getPostMethod();
                $count = Cart::count();
            } catch (Exception $e) {
                throw new Exception("Cart Read Error");
            }

            try {
                $address = $user->address()->find($addressId);
            } catch (Exception $e) {
                throw new Exception("Error Read User Address");
            }

            if ($total < config('cart.post.threshold') && config('cart.post.status')) {
                switch ($postMethod) {
                    case 'bikePost':
                        $postPrice = config('cart.post.bikepost.status') ?  config('cart.post.bikepost.price') : 0;
                        break;

                    case 'normalpost':
                    default:
                        $price = config('cart.post.normalpost.base') + (config('cart.post.normalpost.per') * ($count - 1));
                        $postPrice =  config('cart.post.normalpost.status') ? $price : 0;
                        break;
                }
            }
        } else {
            $user = $isDigital;
        }

        $totalBank = $total - $totalDiscount['discount'] + $postPrice;

        if ($user->xuserid == 2) {
            $totalBank = 1000;
        }

        $data = [
            'xuserid' => $user->xuserid,
            'xinvoice_date' => Carbon::now(),
            'xinvoice_status' => $invoiceStatus,

            'xprovinceid' => $isDigital ? ' ' : $address->xprovinceid,
            'xcityid' => $isDigital ? ' ' : $address->xcityid,
            'xregionid' => $isDigital ? ' ' : $address->xregionid,
            'xparishid' => $isDigital ? ' ' : $address->xparishid,
            'xinvoice_ads_name' => $isDigital ? ' ' : $address->xaddress_name,
            'xinvoice_ads_address' => $isDigital ? ' ' : $address->xaddress_content,
            'xinvoice_ads_phone' => $isDigital ? ' ' : $address->xaddress_phone,
            'xinvoice_ads_postal_code' => $isDigital ? ' ' : $address->xaddress_postal_code,

            'xinvoice_ship' => $postMethod == 'bikePost' ? 'peyk' : ($postMethod == 'normalPost' ? 'post' : 'digital'),
            'xinvoice_ship_price' => $postPrice,
            'xinvoice_shipped' => 0,
            'xinvoice_delivery_status' => 'preparation',

            'xinvoice_subtotal' => $total,
            'xinvoice_total' => $totalBank,
            'xinvoice_discount' => $totalDiscount['discount'],
            'xinvoice_discount_detail' => json_encode($totalDiscount['discountDetail']),
            'xinvoice_copoun_code' => $totalDiscount['discountDetail']['copoun']['code'],
            'xinvoice_copoun_discount' => $totalDiscount['discountDetail']['copoun']['discount'],
        ];

        try {
            $invoice = Invoice::updateById($data);
            $invoice->xinvoice_number = date("Ymd") . $invoice->xinvoiceid;
        } catch (Exception $e) {
            die('[[Error]]');
        }
        if (config('app.shop') == 'product') {
            $this->books->each(function ($book) use ($invoice) {
                $discountPrice = $book->discountPrice();
                $invoice->books()->attach($book->id, [
                    'xinvoiceitem_price' => $book->price,
                    'xinvoiceitem_quantity' => $this->quantity[$book->id],
                    'xinvoiceitem_discount' => $discountPrice['price'] ?? 0,
                    'festival_id' => $discountPrice['type'] == 'festival' ? $discountPrice['id'] : null,
                ]);
            });
        } else {
            $this->books->each(function ($book) use ($invoice) {
                $invoice->books()->attach($book->xbookid, [
                    'xinvoiceitem_price' => $book->xbook_hard_price,
                    'xinvoiceitem_quantity' => $this->quantity[$book->xbookid],
                    'xinvoiceitem_discount' => $book->xbook_hard_discount ?? 0,
                ]);
            });
        }

        $invoice->save();
        return ['invoice' => $invoice, 'totalBank' => $totalBank];
    }

    public function digitalpayment()
    {
        $user = Input::get('user');
        $user = User::find($user);
        if (!$user) {
            die('کاربر مورد نظر یافت نشد...');
        }

        $result = $this->initialPayment('onlinepaymentsend', $user);
        $invoice = $result['invoice'];
        $totalBank = $result['totalBank'];

        try {
            $bank = 'Mellat';
            $a = "Modules\Bank\Entities\\" . $bank . "\\" . $bank;
            $gateway = Bank::make(new $a());

            $gateway->setCallback(env('APP_URL') . '/' . App::getLocale() . '/Payment/verify');
            $gateway->price($totalBank * 10)
                ->invoiceId($invoice->xinvoiceid)
                ->ready();

            $refId = $gateway->refId(); // شماره ارجاع بانک

            $invoice->xref_id = $refId;
            $invoice->save();

            return $gateway->redirect();
        } catch (\Exception $e) {
            echo $e->getMessage();
        }
    }

    public function servicePayment()
    {
        $bank = 'Mellat';
        $postPrice = 0;
        $postMethod = 'digital';
        $mobile = Input::get('mobile');
        $state = Input::get('state');
        $state = json_decode($state, true);
        $productList = [];

        foreach ($state as $key => $value) {
            if ($value['checked']) {
                $productList[] = [
                    'model' => $value['model'],
                    'serialNo' => $value['serialNo'],
                    'planType' => $value['planType'],
                    'durationType' => $value['durationType'],
                    'discountYearCount' => $value['discountYearCount']
                ];
            }
        }
        // $totalBank = 10000;
        $totalBank = $this->gsGetReguarantPrices($mobile, json_encode($productList))->total->sumPriceWithTax;
        $data = [
            'xuserid' => 4,
            'xinvoice_date' => Carbon::now(),
            'xinvoice_status' => 'onlinepaymentsend',

            'xprovinceid' => '',
            'xcityid' => '',
            'xregionid' => '',
            'xparishid' => '',
            'xinvoice_ads_name' => '',
            'xinvoice_ads_address' => '',
            'xinvoice_ads_phone' => $mobile,
            'xinvoice_ads_postal_code' => '',

            'xinvoice_ship' => $postMethod == 'bikePost' ? 'peyk' : ($postMethod == 'normalPost' ? 'post' : 'digital'),
            'xinvoice_ship_price' => $postPrice,
            'xinvoice_shipped' => 0,
            'xinvoice_delivery_status' => 'preparation',

            'xinvoice_subtotal' => $totalBank,
            'xinvoice_total' => $totalBank,
            'xinvoice_discount' => 0,
            'xinvoice_discount_detail' => json_encode($state),
            'xinvoice_copoun_code' => '',
            'xinvoice_copoun_discount' => '',
        ];

        try {
            $invoice = Invoice::updateById($data);
            $invoice->xinvoice_number = date("Ymd") . $invoice->xinvoiceid;
            $invoice->type = 2;
        } catch (Exception $e) {
            die('[[Error]]');
        }

        $invoice->save();
        try {
            $a = "Modules\Bank\Entities\\" . $bank . "\\" . $bank;
            $gateway = Bank::make(new $a());
            $gateway->setCallback(config('app.url') . '/payment/verifyservice');
            $gateway->setbankConfig('mellatRequarant');
            $gateway->price($totalBank)
                ->invoiceId($invoice->xinvoiceid)
                ->ready();

            $refId = $gateway->refId(); // شماره ارجاع بانک

            $invoice->xref_id = $refId;
            $invoice->save();

            return $gateway->redirect();
        } catch (\Exception $e) {
            echo $e->getMessage();
        }
    }
    public function verifyservice()
    {
        try {
            $gateway = Bank::verify();
            $trackingCode = $gateway->trackingCode();
            $invoiceId = $gateway->getinvoiceId();
            $cardNumber = $gateway->cardNumber();

            // $trackingCode = 195908706620;
            // $invoiceId = 15551;

            $invoice = Invoice::where('xinvoiceid', $invoiceId)->first();
            $invoice->xinvoice_status = 'onlinepaymentfinal';
            $invoice->xinvoice_result = $trackingCode;
            $invoice->xinvoice_delivery_status = 'preparation';
            $invoice->save();

            $response['status'] = 'success';


            try {
                $value = [
                    'mobileNo' => $invoice->xinvoice_ads_phone,
                    'productList' => $invoice->xinvoice_discount_detail,
                    'refrenceNumber' => $trackingCode
                ];
                $gsResult = $this->gsRegisterReguarant($value);

                $invoice->xinvoice_description =  $gsResult;
                $invoice->xtransaction_key = $gsResult;
                $invoice->save();
            } catch (\Exception $e) {
                die($e);
            }
        } catch (\Modules\Bank\Exceptions\RetryException $e) {
            $response['status'] = 'retry';
            $response['message'] = $e->getMessage();
        } catch (\Exception $e) {

            if (!($e instanceof \Modules\Bank\Exceptions\RetryException)) {
                $response['status'] = 'failed';
                $response['message'] = $e->getMessage();
                if ($e instanceof \Modules\Bank\Exceptions\BankException) {
                    $invoiceId = $e->invoiceId;
                    if ($invoiceId) {
                        $invoice = Invoice::where('xinvoiceid', $invoiceId)->first();
                        $invoice->xinvoice_status = 'onlinepaymentfailed';
                        $invoice->xinvoice_result = $e;
                        $invoice->save();
                    }
                }
            }
        }

        $this->layout->content = view('cart::index.resultbank', [
            'type' => 'online',
            'invoiceId' => @$invoiceId,
            'response' => @$response,
            'code' => @$trackingCode,
        ]);
    }

    public function onlinepayment()
    {
        //$bank = ucwords(Cart::getBank());
        $bank = Input::get('bank');
        $bank = (!@$bank || $bank == "") ? 'Mellat' : ucwords($bank);

        $result = $this->initialPayment('onlinepaymentsend');
        $invoice = $result['invoice'];
        $totalBank = $result['totalBank'];

        if ($totalBank == 0) {
            $invoice->xinvoice_status = 'onlinepaymentfinal';
            $invoice->xinvoice_delivery_status = 'preparation';
            $invoice->save();
            $response['status'] = 'success';
            $this->layout->content = view('cart::index.resultbank', [
                'type' => 'online',
                'invoiceId' => @$invoice->xinvoice_number,
                'response' => @$response,
                'code' => ' ',
            ]);
            return;
        }

        try {
            $a = "Modules\Bank\Entities\\" . $bank . "\\" . $bank;
            $gateway = Bank::make(new $a());
            $gateway->setCallback(config('app.url') . '/payment/verify');
            $gateway->setbankConfig('mellat');
            $gateway->price($totalBank * 10)
                ->invoiceId($invoice->xinvoiceid)
                ->ready();

            $refId = $gateway->refId(); // شماره ارجاع بانک

            $invoice->xref_id = $refId;
            $invoice->save();

            return $gateway->redirect();
        } catch (\Exception $e) {
            echo $e->getMessage();
        }
    }

    private function getSubTotalDiscount()
    {
        $cartItems = Cart::content();
        if (!$cartItems) {
            return null;
        }

        $wherein = [];
        $quantity = [];
        $cartItems->each(function (CartItem $cartItem) use (&$wherein, &$quantity) {
            $wherein[] = $cartItem->id;
            $quantity[$cartItem->id] = $cartItem->qty;
        });

        $this->quantity = $quantity;

        $total = 0;
        $discount = 0;
        $notComputeTotal = 0;
        $productsId = [];
        $notCompute = config('cart.discount.notCompute');
        if (config('app.shop') == 'product') {
            $this->books = Product::whereIn('id', $wherein)->get();
            $this->books->each(function ($book) use (&$total, &$discount, &$notComputeTotal, $quantity, $notCompute, &$productsId) {
                $productsId[] = $book->id;
                $notComputeTotal += in_array($book->id, $notCompute) ? ($book->price * $quantity[$book->id]) : 0;
                $total += $book->price * $quantity[$book->id];
                $discount += $book->discountPrice()['price'] * $quantity[$book->id];
            });
        } else {
            $this->books = Book::whereIn('xbookid', $wherein)->get();
            $this->books->each(function ($book) use (&$total, &$discount, &$notComputeTotal, $quantity, $notCompute, &$productsId) {
                $productsId[] = $book->xbookid;
                $notComputeTotal += in_array($book->xbookid, $notCompute) ? ($book->xbook_hard_price * $quantity[$book->xbookid]) : 0;
                $total += $book->xbook_hard_price * $quantity[$book->xbookid];
                $discount += $book->xbook_hard_discount * $quantity[$book->xbookid];
            });
        }



        return [
            'subtotal' => $total,
            'discount' => $discount,
            'festivalDiscount' => 0,
            'notComputTotal' => $notComputeTotal,
            'productsId' => $productsId,
        ];
    }

    public function getCopoun()
    {
        return Cart::getCopoun();
    }

    public function updateQuantity($invoice)
    {
        foreach ($invoice->products as $product) {
            $product->quantity -= $product->pivot->xinvoiceitem_quantity;
            $product->save();
        }
    }

    public function verify()
    {
        try {
            $gateway = Bank::verify();
            $trackingCode = $gateway->trackingCode();
            $invoiceId = $gateway->getinvoiceId();
            $cardNumber = $gateway->cardNumber();

            // $trackingCode = 2653333;
            // $invoiceId = 15842;

            $invoice = Invoice::where('xinvoiceid', $invoiceId)->first();
            $invoice->xinvoice_status = 'onlinepaymentfinal';
            $invoice->xinvoice_result = $trackingCode;
            $invoice->xinvoice_delivery_status = 'preparation';
            $invoice->save();

            $this->updateQuantity($invoice);
            $response['status'] = 'success';

            if (config('app.theme') == 'goldiran') {
                try {
                    $logGSData = [];
                    $user = User::find($invoice->xuserid);
                    if (!$user) throw new \Exception('user not find');
                    $mobile = preg_replace("/^\+?98/", '',$user->userInfo->xmobile);
                    $mobile = strlen($mobile) == 11 ? $mobile : (strlen($user->xusername) == 11 ? $user->xusername : null);
                    
                    $value = [
                        'fname' => $user->userInfo->xname ?? ' ',
                        'lname' => $user->userInfo->xfamily ?? ' ',
                        'productcode' => 'xxx',
                        'hometel' => $invoice->xinvoice_ads_phone ?? ' ',
                        'officetel' => ' ',
                        'mobile' =>  $mobile,
                        'svctypeid' => 11,
                        'address' => $invoice->xinvoice_ads_address,
                        'remark' => json_encode(['ship' => $invoice->xinvoice_ship, 'ship_price' => $invoice->xinvoice_ship_price]),
                        'cityid' => $invoice->xcityid,
                        'regionId' => $invoice->xregionid,
                        'parishId' => $invoice->xparishid,
                        'nationalCode' => $user->userInfo->xintcode ?? ' '
                    ];
                    
                    $productList = $invoice->products()->select('part_number AS partNo', 'xinvoiceitem_quantity AS qty')->get()->toJson();
                    
                    if(!$mobile){
                        $logGSData['insertServiceData'] = $value;
                        $value = [
                            'serviceNo' => 0,
                            'price' => $invoice->xinvoice_total * 10,
                            'disCount' => $invoice->xinvoice_discount * 10,
                            'traceNo' => $invoice->xinvoice_result,
                            'paymentDate' =>  date("Y-m-d\TH:m:s", strtotime($invoice->xinvoice_date)),
                            'partList' => $productList,
                            'laborAmount' => round(($invoice->xinvoice_ship_price * 10)/1.09),
                        ];
                        $logGSData['insertOnlineSaleOrderData'] = $value;
                        $invoice->xinvoice_description =  json_encode($logGSData);
                        $invoice->save();
                        throw new \Exception('mobile exception');  
                    } 
                        
                    $serviceType = $this->gsInsertService($value);
                    $serviceType = explode(',', $serviceType)[0];

                    $logGSData['insertServiceData'] = $value;
                    $logGSData['insertServiceResult'] = $serviceType;

                    $value = [
                        'serviceNo' => $serviceType,
                        'price' => $invoice->xinvoice_total * 10,
                        'disCount' => $invoice->xinvoice_discount * 10,
                        'traceNo' => $invoice->xinvoice_result,
                        'paymentDate' =>  date("Y-m-d\TH:m:s", strtotime($invoice->xinvoice_date)),
                        'partList' => $productList,
                        'laborAmount' => round(($invoice->xinvoice_ship_price * 10)/1.09),
                    ];

                    $response['message'] = $this->gsInsertOnLineSaleOrder($value);
                    $logGSData['insertOnlineSaleOrderData'] = $value;
                    $logGSData['insertOnlineSaleOrderResult'] = $response['message'];

                    $invoice->xinvoice_description =  json_encode($logGSData);
                    $invoice->xtransaction_key = $response['message'];
                    $invoice->save();
                } catch (\Exception $e) {
                    die($e);
                }
            }
            try {
                $discountDetail = json_decode($invoice->xinvoice_discount_detail, true);
                $copounid = $discountDetail['copoun']['id'];
                if ($copounid && $discountDetail['accepted'] == 'copoun') {
                    $copoun = Copoun::find($copounid);
                    $copoun->xcopoun_used_count--;
                    $copoun->save();
                }
            } catch (\Exception $e) {
                $response['message'] = $e->getMessage();
            }
        } catch (\Modules\Bank\Exceptions\RetryException $e) {
            $response['status'] = 'retry';
            $response['message'] = $e->getMessage();
        } catch (\Exception $e) {

            if (!($e instanceof \Modules\Bank\Exceptions\RetryException)) {
                $response['status'] = 'failed';
                $response['message'] = $e->getMessage();
                if ($e instanceof \Modules\Bank\Exceptions\BankException) {
                    $invoiceId = $e->invoiceId;
                    if ($invoiceId) {
                        $invoice = Invoice::where('xinvoiceid', $invoiceId)->first();
                        $invoice->xinvoice_status = 'onlinepaymentfailed';
                        $invoice->xinvoice_result = $e;
                        $invoice->save();
                    }
                }
            }
        }

        if ($response['status'] == 'success') {
            //$mobile = Auth::user()->xusername;
            //$smsResponse = SMS::send( $invoice ? [ $trackingCode, $invoice->xinvoice_number] : $trackingCode, $mobile,null,'invoiceSuccess');
        }

        Cart::destroy();

        $this->layout->content = view('cart::index.resultbank', [
            'type' => 'online',
            'invoiceId' => @$invoiceId,
            'response' => @$response,
            'code' => @$trackingCode,
        ]);
    }

    public function offlinepayment()
    {
        $addressId = Input::get('address');
        $cartItems = Cart::content();
        $wherein = [];
        $quantity = [];
        $cartItems->each(function (CartItem $cartItem) use (&$wherein, &$quantity) {
            $wherein[] = $cartItem->id;
            $quantity[$cartItem->id] = $cartItem->qty;
        });

        $books = Book::whereIn('xbookid', $wherein)->get();
        $total = 0;
        $discount = 0;

        $books->each(function ($book) use (&$total, &$discount, $quantity) {
            $total += $book->xbook_hard_price * $quantity[$book->xbookid];
            $discount += $book->xbook_hard_discount * $quantity[$book->xbookid];
        });
        $user = Auth::user();
        $address = $user->address()->find($addressId);
        $data = [
            'xuserid' => $user->xuserid,
            "xinvoice_number" => date("Ymdhis"),
            'xinvoice_date' => Carbon::now(),
            'xinvoice_subtotal' => $total,
            'xinvoice_total' => $total - $discount,
            'xinvoice_status' => 'offlinepaymentsend',
            'xprovinceid' => $address->xprovinceid,
            'xinvoice_address' => $address->xaddress_content,
            'xinvoice_phone' => $address->xaddress_phone,
            'xinvoice_ship' => 'post',
            'xinvoice_shipped' => 0,
        ];

        try {
            $invoice = Invoice::updateById($data);
        } catch (Exception $e) {
            $this->layout->title = trans('اتمام ثبت سفارش');
            $this->layout->content = view('cart::index.resultbank', [
                'type' => 'offline',
                'response' => ['status' => 'failed'],
                'code' => $data['xinvoice_number'],
            ]);
        }

        $books->each(function ($book) use ($invoice, $quantity) {
            $invoice->books()->attach($book->xbookid, [
                'xinvoiceitem_price' => $book->xbook_hard_price,
                'xinvoiceitem_quantity' => $quantity[$book->xbookid],
                'xinvoiceitem_discount' => $book->xbook_hard_discount,
            ]);
        });

        Cart::destroy();
        $this->layout->title = 'اتمام ثبت سفارش';
        $this->layout->content = view('cart::index.resultbank', [
            'type' => 'offline',
            'response' => ['status' => 'success'],
            'code' => $data['xinvoice_number'],
        ]);
    }

    public function agentPayment()
    {
        try {
            $result = $this->initialPayment('agentpayment');
            $invoice = $result['invoice'];
            $totalBank = $result['totalBank'];

            $agent = Agent::where('xuserid', Auth::id())->first();
            $agent->xgrand_consumed = $totalBank;
            $agent->save();

            Cart::destroy();
            $this->layout->title = 'اتمام ثبت سفارش';
            $this->layout->content = view('cart::index.resultbank', [
                'type' => 'offline',
                'response' => ['status' => 'success'],
                'code' => $invoice->xinvoice_number,
                'invoiceId' => @$invoice->xinvoiceid,
            ]);
        } catch (Exception $e) {
            $this->layout->title = trans('اتمام ثبت سفارش');
            $this->layout->content = view('cart::index.resultbank', [
                'type' => 'offline',
                'response' => ['status' => 'failed'],
                'code' => @$invoice ? $invoice->xinvoice_number : ' ',
                'invoiceId' => @$invoice ? $invoice->xinvoiceid : ' ',
            ]);
        }
    }

    public function cartPayment()
    {
        try {
            $result = $this->initialPayment('cartpayment');
            $invoice = $result['invoice'];
            $totalBank = $result['totalBank'];

            $invoice->xinvoice_result = 1234;
            $invoice->xref_id = 55555;
            $invoice->save();

            Cart::destroy();
            $this->layout->title = 'اتمام ثبت سفارش';
            $this->layout->content = view('cart::index.resultbank', [
                'type' => 'offline',
                'response' => ['status' => 'success'],
                'code' => $invoice->xinvoice_number,
                'invoiceId' => @$invoice->xinvoiceid,
            ]);
        } catch (Exception $e) {
            $this->layout->title = trans('اتمام ثبت سفارش');
            $this->layout->content = view('cart::index.resultbank', [
                'type' => 'offline',
                'response' => ['status' => 'failed'],
                'code' => @$invoice ? $invoice->xinvoice_number : ' ',
                'invoiceId' => @$invoice ? $invoice->xinvoiceid : ' ',
            ]);
        }
    }
}
