<?php
namespace Modules\Cart\Http\Controllers\Index;

use App\Http\Controllers\IndexController;
use Cart;
use Input;
use Modules\Book\Models\Book;
use DB;
use Modules\Festival\Models\Festival;

class CartController extends IndexController {

    /**
     * Show the application cart to the user.
     *
     * @return Response
     */
    public function index($id, $title = '') {
        $title = t("cart");
        $this->layout->title2 = $title;
        $this->layout->content = view('cart::index.cart');
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \App\Product  $product
     * @return \Illuminate\Http\Response
     */
    public function store() {
        $id = Input::get('id');
        $type = Input::get('type', 'product');
        
        $class = config("cart.classes.{$type}.namespace", Book::class);
        
        $result = $this->addToCart($id,$type);
        
        if ($result != false) {
            $result->associate($class);
            return response()->json(['success' => true, 'count' => Cart::count()]);
        } else {
            return response()->json(['success' => false, 'count' => Cart::count()], 401);
        }
    
       // die(json_encode(t("product not find.")));
    }

    public function addToCart($id,$type){
        $class = config("cart.classes.{$type}.namespace", Book::class);
        $title = config("cart.classes.{$type}.title", 'xbook_title');
        $price = config("cart.classes.{$type}.price", 'xbook_hard_price');
        $quantity = config("cart.classes.{$type}.quantity", 'xbook_quantity');
        $discount = config("cart.classes.{$type}.discount", 'xbook_hard_discount');
        $relOptions = config("cart.classes.{$type}.relationOptions", null);
        $options = config("cart.classes.{$type}.options", null);

        $product = $class::findWith($id);
        

        if ($product && $product->count() > 0) {
            $optionList = [];
            if ($options) {
                foreach ($options as $key => $value) {
                    $optionList[$key] = $product->$value;
                }
            }

            if ($relOptions) {
                foreach (@$relOptions as $key => $value) {
                    if ($product->$key && $product->$key->count() > 0) {
                        if ($value['multi']) {
                            $optionList[$key] = implode('،', $product->$key->pluck($value['data'])->toArray());
                        } else {
                            $optionList[$key] = $product->$key->{$value['data']};
                        }
                    }

                }
            }
            $discountPrice = $product->discountPrice();
            $cartItem = Cart::search(function ($cartItem, $rowId) use ($id) {
                return $cartItem->id === $id;
            })->first();
            if (1 > $product->$quantity or ($cartItem && $cartItem->qty  >= 12)) {
                return response()->json(['success' => false, 'msg' => 'کالا به این تعداد موجود نمی باشد.'], 400);
            }
            
            if($discountPrice['type'] == 'festival' && self::isFestivalQuantityLimit($id,$discountPrice['id'],$cartItem ? $cartItem->qty : 0,1)) {
                return response()->json(['success' => false, 'msg' => 'کالا به این تعداد موجود نمی باشد.'], 400);
            }
            
            $result = Cart::add($id, $product->$title, 1, $product->$price ?: 0, $discountPrice['price'] ?: 0, $product->$quantity ?: 0, $optionList);
            return $result;
        }
        return null;
    }

    public function isFestivalQuantityLimit($productid, $festivalid,$cartQty, $quantity = 1){
        $user = \Auth::user();
        // $festivalid = 5;
        // $productid = 1047;
        if($user){
            $productCount = DB::table('xxshop_invoice')
                ->whereIn('xinvoice_status',['onlinepaymentfinal','offlinepaymentok','cartpaymentAccept'])
                ->where('xuserid',$user->xuserid)
                ->join('xxshop_invoiceitem','xxshop_invoice.xinvoiceid','=','xxshop_invoiceitem.xinvoiceid')
                ->where('xxshop_invoiceitem.festival_id',$festivalid)
                ->where('xxshop_invoiceitem.xbookid',$productid)
                ->select(DB::raw('SUM(xinvoiceitem_quantity) AS sumQty'))
                ->value('sumQty');
        }    
        
        $festivalCount = Festival::find($festivalid)->products()->where('product_id',$productid)->withPivot('maxbuy')->value('maxbuy');    
        return ($productCount ?? 0 + $quantity +  $cartQty <= $festivalCount) ? false : true;
        
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update() {
        $id = Input::get('id');
        $qty = (int) Input::get('qty');
        $type = Input::get('type', 'book');
        $itemid = config("cart.classes.{$type}.id", 'xbookid');

        $class = config("cart.classes.{$type}.namespace", Book::class);
        $quantity = config("cart.classes.{$type}.quantity", 'xbook_quantity');
        $cartItem = Cart::get($id);
        $product = $class::findWith($cartItem->id);

        if ($qty < 1 or $qty > $product->$quantity or $cartItem->qty + $qty > 12) {
            return response()->json(['success' => false, 'msg' => 'کالا به این تعداد موجود نمی باشد.'], 400);
        }
        
        $discountPrice = $product->discountPrice();
        
        if($discountPrice['type'] == 'festival' && self::isFestivalQuantityLimit($product->$itemid,$discountPrice['id'],0,$qty)){
            return response()->json(['success' => false, 'msg' => 'کالا به این تعداد موجود نمی باشد.'], 400);
        }

        Cart::update($id, $qty);

        return response()->json(Cart::totalAll()->merge(Cart::itemTotalAll($id)));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function remove() {
        $id = Input::get('id');
        Cart::remove($id);

        return response()->json(Cart::totalAll());
    }

    public function addCopoun() {
        $code = Input::get('copounCode');
        Cart::setCopoun($code);
        $discount = Cart::verfiyCopounDiscount();

        if (!$discount) {
            return response()->json(['success' => false, 'message' => 'کد تخفیف وارد شده اعتبار ندارد'], 404);
        }

        return response()->json(Cart::totalAll());
    }

    public function removeCopoun() {
        Cart::removeCopoun();
        return response()->json(Cart::totalAll());
    }

}
