<?php namespace Modules\Cart\Http\Controllers\Admin;

use App\Http\Controllers\BackendController;
use Modules\Cart\Models\Transaction;

use Config;
use Input;
use File;
use App;
use DB;

class TransactionController extends BackendController {
    public $title = "transaction";

    //## list
	public function index()
	{
        $this->field[] =  array('php' => 'echo FarsiLib::convertDigit($item["invoiceid"]);', 'name' =>  @t('invoice'), 'css' => 'width: 10%', 'sortable' => 'invoiceid');
        $this->field[] =  array('php' => 'echo $item["port"];', 'name' =>  @t('bank'), 'css' => 'width: 10%', 'sortable' => 'port'); 
        $this->field[] =  array('php' => 'echo FarsiLib::faNormalizeNumber($item["price"]);', 'name' => @t('price'), 'css' => 'width: 10%', 'sortable' => 'price');
        
        $this->field[] =  array('php' => 'echo FarsiLib::convertDigit($item["tracking_code"]);', 'name' => @t('tracking code'), 'css' => 'width: 10%', 'sortable' => 'tracking_code');
        $this->field[] =  array('php' => 'echo FarsiLib::convertDigit($item["card_number"]);', 'name' => @t('card number'), 'css' => 'width: 10%', 'sortable' => 'card_number');
        $this->field[] =  array('php' => 'echo FarsiLib::g2jDate($item["created_at"],true);', 'name' => @t('date'), 'css' => 'width: 10%', 'sortable' => 'created_at');
        $this->field[] =  array('php' => 'echo htmlStatus($item["status"],["SUCCEED"=>"success","FAILED"=>"danger","INIT"=>"default"]);', 'name' => @t('status'), 'css' => 'width: 10%', 'sortable' => 'status');

        $this->list = Transaction::getResult()
            ->whereRaw($this->query->where)
            ->orderByRaw($this->query->order)
            ->havingRaw($this->query->having);
        
        $this->paginate();
        $this->layout->content->listBtn['hideDelete'] = true;
        $this->layout->content->listBtn['hideEdit'] = true;
	}

    //## new
    public function create($id = 0)
    {
        $this->layout->title = $this->title;
    }

    //## edit
    public function edit($id)
    {
        $this->layout->content->list = Cart::find($id);
        $this->layout->content->imgExist = File::exists(config('upload.' . config('app.controller')) . "/$id");
        $this->layout->title = $this->title;
        $this->layout->content->parentList = Cart::pluck('xcart_title','xcartid')->prepend( 'بدون والد')->forget($id);
    }

    //## store
    public function store($id)
    {
        $frm = Input::get('frm');
        $book = Cart::updateById($frm,$id);
        $this->saveFile($id);
        die('[[OK]]');
        
    }

    //## delete
    public function delete($id)
    {
        Cart::remove($id);
        
    }

    //## delete Image
    public function deleteImage($id)
    {
        File::delete(config('upload.' . config('app.controller'))  . "/$id");
        die('[[OK]]');
    }

    //## set combo
    public function setCombo()
    {
         $this->layout->GroupList = $this->layout->content->GroupList = [1];
         $this->layout->SubGroupList  = $this->layout->content->SubGroupList  = [1];
        
    }

}