<?php namespace Modules\Cart\Http\Controllers\Admin;

use App\Http\Controllers\BackendController;
use Config;
use File;
use Input;
use Modules\Cart\Models\Returned;
use Modules\Book\Models\SubCategory;
use Modules\Shop\Models\Group;
use DB;
use Modules\Shop\Models\Product;

class ReturnedController extends BackendController {
    public $title = "returned";

    //## list
    public function index() {
        $this->field[] = array('php' => 'echo $item["xinvoice_number"];', 'name' => @t('invoice'), 'css' => 'width: 10%', 'sortable' => 'xinvoice_number');
        $this->field[] = array('php' => 'echo $item["name"];', 'name' => @t('product'), 'css' => 'width: 10%', 'sortable' => 'product_id');
        $this->field[] = array('php' => 'echo $item["reason_name"];', 'name' => @t('reason'), 'css' => 'width: 10%', 'sortable' => 'reason_name');
        $this->field[] = array('php' => 'echo htmlStatus($item["status"],["1"=>"success","0"=>"danger"]);', 'name' => @t('status'), 'css' => 'width: 10%');

        $this->list = Returned::getResult();
        $this->paginate();

    }

    //## new
    public function create($id = 0) {
        $this->layout->title = $this->title;
    }

    //## edit
    public function edit($id) {
        $this->layout->content->list = Returned::find($id);
        $this->layout->title = $this->title;

    }

    //## store
    public function store($id) {
        $frm = Input::get('frm');
        $Returned = Returned::updateById($frm, $id);
        die('[[OK]]');

    }

    //## delete
    public function delete($id) {
        Returned::remove($id);

    }

    //## delete Image
    public function deleteImage($id) {
        File::delete(config('upload.' . config('app.controller')) . "/$id");
        die('[[OK]]');
    }

    //## set combo
    public function setCombo() {
        $this->layout->reasonList = $this->layout->content->reasonList = [
            1 =>'کالا ایراد فنی دارد',
            2 =>'کالا دارای خط و خش ظاهری می باشد',
            3 =>'کالا مطابق با سفارش ثبت شده نمی باشد',
            4 =>'از خرید منصرف شدم',
            5 =>'کالا را اشتباه سفارش دادم',
            6 =>'قطعه با دستگاه مطابقت ندارد'
        ];
        
    }

}