<?php namespace Modules\Cart\Http\Controllers\Admin;

use App\Http\Controllers\BackendController;
use Config;
use DB;
use File;
use Input;
use Modules\Account\Models\UserInfo;
use Modules\Cart\Exports\InvoicesExport;
use Modules\Cart\Exports\InvoicesSheetAllExport;
use Modules\Cart\Models\Invoice;
use Modules\Home\Models\Province;
use Modules\Home\Models\County;
use Modules\Home\Models\Region;
use Modules\Home\Models\Parish;
use Modules\Goldiran\Traits\GS;
use PDF;
use Auth;

class InvoiceController extends BackendController {
    use GS;
    public $title = "invoice";

    //## list
    public static $model = 'App\Post';
    public static $displayInNavigation = false;

    public function fields() {
        return [
            Id::make('id')->field('xinvoiceid')->sortable(),
            Text::make('invoice')->field('xinvoice_number')->sortable()->filter(),
            FarsiDate::make('date')->field('xinvoice_date')->sortable(),
            Text::make('price')->field(function () {
                return $this->user->xname . ' ' . $this->user->xfamily;
            })->sortable(),
        ];
    }

    public function index() {

        $this->field[] = array('php' => 'echo FarsiLib::convertDigit($item["xinvoice_number"]);', 'name' => @t('invoice number'), 'css' => 'width: 10%', 'sortable' => 'xinvoice_number');
        $this->field[] = array('php' => 'echo $item["xname"]." ".$item["xfamily"];', 'name' => @t('name'), 'css' => 'width: 10%', 'sortable' => 'xuserid');
        $this->field[] = array('php' => 'echo $item["xusername"];', 'name' => @t('mobile'), 'css' => 'width: 10%', 'sortable' => 'xusername');
        $this->field[] = array('php' => 'echo FarsiLib::g2jDate($item["xinvoice_date"],true);', 'name' => @t('date'), 'css' => 'width: 10%', 'sortable' => 'xinvoice_date');

        $this->field[] = array('php' => 'echo FarsiLib::faNormalizeNumber($item["xinvoice_total"]);', 'name' => @t('total'), 'css' => 'width: 10%', 'sortable' => 'xinvoice_total');

        $this->field[] = array('php' => 'echo FarsiLib::faNormalizeNumber($item["xinvoice_discount"]);', 'name' => @t('discount'), 'css' => 'width: 10%', 'sortable' => 'xinvoice_discount');

        $this->field[] = array('php' => 'echo t($item["xinvoice_ship"]);', 'name' => @t('delivery'), 'css' => 'width: 10%', 'sortable' => 'xinvoice_ship');

        $this->field[] = array('php' => 'echo htmlStatus($item["xinvoice_delivery_status"],["queue"=>"default","approve"=>"default","preparation"=>"default","delivered"=>"success","failed"=>"danger"]);', 'name' => @t('delivery status'), 'css' => 'width: 10%', 'sortable' => 'xinvoice_delivery_status');
        
        $this->field[] = array('php' => 'echo htmlStatus($item["xinvoice_status"],["onlinepaymentfinal"=>"success","cartpaymentAccept"=>"success","offlinepaymentsend"=>"danger","onlinepaymentfailed"=>"danger","offlinepaymentok" => "warning"]);', 'name' => @t('payment status'), 'css' => 'width: 10%', 'sortable' => 'xinvoice_status');

        $this->field[] = array('php' => 'if($item["xtransaction_key"]) echo "<div class=\"text-center\"><span class=\"label label-sm label-success\">موفق</span></div>"; else echo "<div class=\"text-center\"><span class=\"label label-sm label-danger\">ناموفق</span></div>";', 'name' => @t('status').' GS', 'css' => 'width: 10%', 'sortable' => 'xinvoice_delivery_status');

        $this->list = Invoice::getResult();
        if(Auth::id() != 2)
            $this->list->whereNotIn('xinvoice_status',['onlinepaymentsend']);

        $this->paginate();
        $this->layout->content->listBtn['hideDelete'] = true;
        $this->layout->content->listBtn['hideEdit'] = true;
        $this->layout->content->listBtn['showAddressDetail'] = true;
        $this->layout->content->listBtn['showItems'] = true;
        $this->layout->content->listBtn['showTransaction'] = true;
        $this->layout->toolbar['showTools'] = true;
        $this->layout->toolbar['showAddressPdf'] = true;
        $this->layout->toolbar['showAllExportExcel'] = true;
        $this->layout->content->listBtn['showCheckbox'] = true;
        
    }

    //## new
    public function create($id = 0) {
        $this->layout->title = $this->title;
    }

    //## edit
    public function edit($id) {
        $this->layout->content->list = Invoice::find($id);
        $this->layout->content->imgExist = File::exists(config('upload.' . config('app.controller')) . "/$id");
        $this->layout->title = $this->title;
        $this->layout->content->parentList = Invoice::pluck('xcart_title', 'xcartid')->prepend('بدون والد')->forget($id);
    }

    //## store
    public function store($id) {
        $frm = Input::get('frm');
        $invoice = Invoice::updateById($frm, $id);
        die('[[OK]]');

    }

    //## delete
    public function delete($id) {
        Invoice::remove($id);

    }

    //## delete Image
    public function deleteImage($id) {
        File::delete(config('upload.' . config('app.controller')) . "/$id");
        die('[[OK]]');
    }

    //## set combo
    public function setCombo() {
        $this->layout->statusList = $this->layout->content->statusList = Invoice::fetchEnum('xinvoice_status');
        $this->layout->deliveryStatusList = $this->layout->content->deliveryStatusList = array_merge(array_map(function ($value) {return t($value);}, Invoice::fetchEnum('xinvoice_delivery_status')), ['' => '']);
        $this->layout->content->shipList = $this->layout->shipList = array_merge(array_map(function ($value) {return t($value);}, Invoice::fetchEnum('xinvoice_ship')), ['' => '']);
        $this->layout->userList = $this->layout->content->userList = UserInfo::select([DB::Raw("CONCAT(xname, ' ', xfamily) AS xfullname"), 'xuserid'])->pluck('xfullname', 'xuserid')->prepend('', '');

    }

    public function editAddressDetail($id) {
        $this->layout->title = 'address detail';
        $this->layout->storeMethod = 'storeAddressDetail';
        $this->layout->content = view('cart::admin.edit.invoiceAdressDetail');
        $this->layout->content->list = Invoice::find($id);

        $this->layout->content->shipList = array_map(function ($value) {return t($value);}, Invoice::fetchEnum('xinvoice_ship'));
        $this->layout->content->deliveryStatusList = array_map(function ($value) {return t($value);}, Invoice::fetchEnum('xinvoice_delivery_status'));
        $this->layout->content->provinceList = Province::all()->pluck('name', 'id');
        $this->layout->content->cityList = County::all()->pluck('name', 'id');
        $this->layout->content->regionList = Region::all()->pluck('name', 'id');
        $this->layout->content->parishList = Parish::all()->pluck('name', 'id');
        
    }

    public function storeAddressDetail($id) {
        $frm = Input::get('frm');
        $invoice = Invoice::updateById($frm, $id);

        die('[[OK]]');
    }

    public function editItems($id) {
        $this->layout->title = 'items';
        $this->layout->storeMethod = 'storeitems';
        $this->layout->content = view('cart::admin.edit.invoiceItems');
        $this->layout->content->list = Invoice::find($id);
    }

    public function editTransaction($id) {
        $this->layout->title = 'transactions';
        $this->layout->storeMethod = 'storeTransaction';
        $this->layout->content = view('cart::admin.edit.itemTransaction');
        $invoice = Invoice::find($id);
        $this->layout->content->invoice = $invoice;
    }

    public function storeTransaction($id) {
        $frm = Input::get('frm');
        if ($frm) {
            $frm['xinvoice_status'] = 'cartpaymentAccept';
            $invoice = Invoice::updateById($frm, $id);
        }

        die('[[OK]]');
    }

    public function excelExport() {
        $checkall = Input::get('checkall');
        $listchk = Input::get('listchk');

        $this->list = Invoice::getResult()->leftJoin('xxshop_gateway_transactions as t', 't.invoiceid', '=', 'i.xinvoiceid');
 
        $this->list->columns = ['i.xinvoiceid','i.xuserid','i.xinvoice_number','i.xinvoice_code','i.xinvoice_discount',
        'i.xinvoice_discount_detail','i.xinvoice_total','i.xinvoice_subtotal','i.xinvoice_status','i.xinvoice_result',
        'i.xtransaction_key','i.xref_id','i.xinvoice_ads_name','i.xinvoice_ads_address','i.xinvoice_ads_phone','i.xinvoice_ads_postal_code','i.xprovinceid',
        'i.xinvoice_delivery_status','i.xinvoice_delivery_time','i.xinvoice_ship','i.xinvoice_ship_price','i.xinvoice_ship_code','i.xinvoice_tax','i.xinvoice_shipped','i.xinvoice_description',
         "ui.xname", "ui.xfamily", "u.xusername", "t.port", "t.tracking_code", "t.card_number"];

        if(config('app.shop') == 'product'){
            $this->list->leftJoin('xxshop_invoiceitem as ii','ii.xinvoiceid','=','i.xinvoiceid')
                ->leftJoin('shop_product as sp','sp.id','=','ii.xbookid');
            $this->list->addSelect(['sp.name', 'sp.part_number', 'ii.xinvoiceitem_price', 'ii.xinvoiceitem_discount', 'ii.xinvoiceitem_quantity']);    
        }
        $this->list->selectRaw("i.xinvoice_total - i.xinvoice_ship_price, PDATE(i.xinvoice_date)");

        if (!$checkall && $listchk) {
            $this->list->whereIn('i.xinvoiceid', array_keys($listchk));
        }

        $this->setQueryToList();

        if (!$this->list->orders) {
            $this->list->orders = [[
                "column" => "xinvoiceid",
                "direction" => "desc",
            ]];
        }

        return (new InvoicesExport($this->list))->download('invoices.xlsx');
    }

    public function excelAllExport() {
        $checkall = Input::get('checkall');
        $listchk = Input::get('listchk');

        $this->list = Invoice::getOverItemsInvoice();
        
        $this->list->columns = ['i.xinvoice_number', DB::Raw('PDATE(xinvoice_date)'), 'b.xbook_title', "ii.xinvoiceitem_price",  "ii.xinvoiceitem_quantity"];

        if (!$checkall && $listchk) {
            $this->list->whereIn('i.xinvoiceid', array_keys($listchk));
        }
        
        $this->setQueryToList();

        if (!$this->list->orders) {
            $this->list->orders = [[
                "column" => "i.xinvoiceid",
                "direction" => "desc",
            ]];
        }
        
        $query1 = clone $this->list;
        $this->list->groupBy('i.xinvoiceid');
        $this->list->columns = ['xinvoice_subtotal','xinvoice_discount','xinvoice_total'];
        return (new InvoicesSheetAllExport($query1,$this->list))->download('invoices.xlsx');
    }

    public function resendGS($id){
        //$id = Input::get('id');
        $invoice = Invoice::find($id);
        $data = json_decode($invoice->xinvoice_description,true);

        if(!$data['insertServiceResult']){
            $data['insertServiceResult'] = $this->gsInsertService($data['insertServiceData']);
            sleep(1);
        }
        if(!$data['insertServiceResult'])
            die(json_encode(['type' => 'failed', 'message' => 'عدم بروزرسانی در سامانه GS']));

        $data['insertOnlineSaleOrderData']['serviceNo'] = $data['insertServiceResult'];
        $data['insertOnlineSaleOrderResult'] = $this->gsInsertOnLineSaleOrder($data['insertOnlineSaleOrderData']);
        if(!$data['insertOnlineSaleOrderResult'])
            die(json_encode(['type' => 'failed', 'message' => 'عدم بروزرسانی در سامانه GS']));

        if ($data['insertOnlineSaleOrderResult']){
            $invoice->xinvoice_description =  json_encode($data);
            $invoice->xtransaction_key = $data['insertOnlineSaleOrderResult'];
            $invoice->save();
        }
        die(json_encode(['type' => 'success', 'message' => trans('language.information successfully updated')]));
        
        
    }

    public function pdfExport() {
        $checkall = Input::get('checkall');
        $listchk = Input::get('listchk');

        $invoice = Invoice::with('items');
        if ($listchk) {
            $invoice->whereIn('xinvoiceid', array_keys($listchk));
        }
        $invoice->take(50);
        $pdf = PDF::loadView('cart::admin.pdf.invoice', ['invoices' => $invoice->get()])->setRtl();
        return $pdf->download('invoice.pdf');

    }

    public function pdfAddressExport() {
        $checkall = Input::get('checkall');
        $listchk = Input::get('listchk');

        $invoice = Invoice::with('items');
        if (!$checkall && $listchk) {
            $invoice->whereIn('xinvoiceid', array_keys($listchk));
        }

        $pdf = PDF::loadView('cart::admin.pdf.address', ['invoices' => $invoice->get()])->setRtl();
        return $pdf->download('address.pdf');

    }

}