<?php namespace Modules\Cart\Http\Controllers\Admin;

use App\Http\Controllers\BackendController;
use Config;
use File;
use Input;
use Modules\Cart\Models\Copoun;
use Modules\Book\Models\SubCategory;
use Modules\Shop\Models\Group;
use DB;
use Modules\Account\Models\User;
use Modules\Shop\Models\Product;

class CopounController extends BackendController {
    public $title = "copoun";

    //## list
    public function index() {
        $this->field[] = array('php' => 'echo $item["xcopoun_name"];', 'name' => @t('name'), 'css' => 'width: 10%', 'sortable' => 'xcopoun_name');
        $this->field[] = array('php' => 'echo $item["xcopoun_code"]?:"بدون والد";', 'name' => @t('code'), 'css' => 'width: 10%', 'sortable' => 'xcopoun_code');
        $this->field[] = array('php' => 'echo $item["xcopoun_discount"];', 'name' => @t('discount'), 'css' => 'width: 10%', 'sortable' => 'xcopoun_discount');
        $this->field[] = array('php' => 'echo $item["xcopoun_used_count"];', 'name' => @t('count'), 'css' => 'width: 10%', 'sortable' => 'xcopoun_used_count');
        $this->field[] = array('php' => 'echo htmlStatus($item["xcopoun_status"],["1"=>"success","0"=>"danger"]);', 'name' => @t('status'), 'css' => 'width: 10%');

        $this->list = Copoun::getResult();
        $this->paginate();

    }

    //## new
    public function create($id = 0) {
        $this->layout->title = $this->title;
    }

    //## edit
    public function edit($id) {
        $this->layout->content->list = Copoun::find($id);
        $this->layout->title = $this->title;

    }

    //## store
    public function store($id) {
        $frm = Input::get('frm');
        $products = Input::get('products');
        $users = Input::get('users');
        $frm['xcopoun_productids'] = json_encode($products);
        $copoun = Copoun::updateById($frm, $id);
        $copoun->user()->detach();
        if($users)
            $copoun->user()->attach(array_values($users));
        
        
        die('[[OK]]');

    }

    //## delete
    public function delete($id) {
        Copoun::remove($id);

    }

    //## delete Image
    public function deleteImage($id) {
        File::delete(config('upload.' . config('app.controller')) . "/$id");
        die('[[OK]]');
    }

    //## set combo
    public function setCombo() {
        $this->layout->GroupList = $this->layout->content->GroupList = [1];
        $this->layout->SubGroupList = $this->layout->content->SubGroupList = [1];
        $this->layout->productList = $this->layout->content->productList = Product::pluck('name', 'id');
        //$this->layout->userList = $this->layout->content->userList = User::pluck('xusername', 'xuserid');

        if (config('app.shop') == 'product')
            $this->layout->subCategoryList = $this->layout->content->subCategoryList = Group::join('shop_group as g2','g2.id','=','shop_group.parent_id')
            ->select(DB::raw("CONCAT(g2.name,'-',shop_group.name) as parentname"), 'shop_group.id')    
            ->pluck('parentname','id')
            ->prepend('', '');
           
        else
            $this->layout->subCategoryList = $this->layout->content->subCategoryList = SubCategory::pluck('xsubcategory_name', 'xsubcategoryid')->prepend('', '');
        
    }

       /*
   AJAX request
   */
   public function getUserAjax(){

    $search = Input::get('search');
    
    if($search == ''){
       $users = User::get();
    }else{
       $users = User::where('xusername', 'like', '%' .$search . '%')->get();
    }

    $response = array();
    foreach($users as $user){
       $response[] = array(
            "id"=>$user->xuserid,
            "text"=>$user->xusername
       );
    }

    echo json_encode($response);
    exit;
 }

}