<?php

namespace Modules\Cart\Exports;

use Maatwebsite\Excel\Concerns\Exportable;
use Maatwebsite\Excel\Concerns\FromQuery;
use Maatwebsite\Excel\Concerns\WithHeadings;

class InvoicesExport implements FromQuery, WithHeadings {
    use Exportable;

    public function __construct($query) {
        $this->query = $query;
    }

    public function headings(): array
    {
        return [
            'شناسه',
            'شناسه کاربر',
            'شماره  سفارش',
            'کد  سفارش',
            'مجموع تخفیفات',
            'جزئیات  تخفیف',
            'جمع  فاکتور ',
            ' جمع مبلغ ناخالص',
            'وضعیت  پرداخت ',
            'نتیجه  پرداخت بانکی ',
            'کد تراکنش',
            'کد مرجع',
            'نام و نام خانوادگی  گیرنده',
            'آدرس',
            'تلفن',
            'کد پستی',
            'شناسه  استان',
            'وضعیت  سفارش',
            'تاریخ ارسال',
            'نحوه ارسال',
            'هزینه ارسال',
            'کد مرسوله',
            'مالیات',
            'وضعیت ارسال مرسوله',
            'توضیحات',
            'نام کاربر',
            'نام خانوادگی کاربر',
            'نام کاربری',
            'بانک',
            'کد بانکی',
            'شماره کارت',
            'نام کالا',
            'شماره سریال کالا',
            'قیمت کالا',
            'تخفیف کالا',
            'تعداد کالا',
            'جمع فاکتور بدون هزینه ارسال',
            'تاریخ شمسی',
        ];
    }

    public function query() {
        return $this->query;
    }
}