<?php

return [
    'name' => 'Cart',
    'lang' => [
        'default' => 'message',
    ],

    'classes' => [
        'book' => [
            'namespace' => '\Modules\Book\Models\Book',
            'id' => 'xbookid',
            'title' => 'xbook_title',
            'price' => 'xbook_hard_price',
            'quantity' => 'xbook_quantity',
            'relationOptions' => [
                'author' => ['multi' => true, 'data' => 'xauthor_name'],
                'translator' => ['multi' => true, 'data' => 'xauthor_name'],
                'publisher' => ['multi' => false, 'data' => 'xpublisher_name'],
            ],
        ],

        'product' => [
            'namespace' => '\Modules\Shop\Models\Product',
            'id' => 'id',
            'title' => 'name',
            'price' => 'price',
            'quantity' => 'quantity',
            'discount' => 'discount',
            'relationOptions' => [
                
            ],
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Default tax rate
    |--------------------------------------------------------------------------
    |
    | This default tax rate will be used when you make a class implement the
    | Taxable interface and use the HasTax trait.
    |
     */

    'tax' => 0,

    'post' => [
        'status' => true,
        'threshold' => 99999999,
        'bikepost' => ['price' => 0, 'status' => false],
        'normalpost' => ['base' => 11000, 'per' => 2000, 'status'=> true],
        'notCompute' => [648],
    ],

    'discount' => [
        'threshold' => 99999999,
        'notCompute' => [1160],
    ],

    /*
    |--------------------------------------------------------------------------
    | Destroy the cart on user logout
    |--------------------------------------------------------------------------
    |
    | When this option is set to 'true' the cart will automatically
    | destroy all cart instances when the user logs out.
    |
     */

    'destroy_on_logout' => false,

    /*
    |--------------------------------------------------------------------------
    | Default number format
    |--------------------------------------------------------------------------
    |
    | This defaults will be used for the formated numbers if you don't
    | set them in the method call.
    |
     */

    'format' => [

        'decimals' => 0,

        'decimal_point' => '.',

        'thousand_seperator' => ',',

    ],

    'allow_multiple_coupons' => true,

    /*
    |--------------------------------------------------------------------------
    | Payment Gateways
    |--------------------------------------------------------------------------
    |
    | List of payment gateways.
    |
     */
    'gateways' => [
        'paypal' => Amsgames\LaravelShopGatewayPaypal\GatewayPayPal::class,
        'paypalExpress' => Amsgames\LaravelShopGatewayPaypal\GatewayPayPalExpress::class,
    ],
];
