@section('content')
    <div class="col-md-12">
        <div class="table-responsive">
            <table class="table table-bordered table-striped">
                <tr>
                    <td>@lang('language.title'):</td>
                    <td>
                        <div class="form-group">
                            <div class="input-icon">
                                <i class="fa fa-user"></i>
                                {!! Form::text('frm[xcategory_name]', @$list['xcategory_name'], array('class' => 'form-control'))  !!}
                            </div>
                        </div>
                    </td>
                </tr>

                <tr>
                    <td>@lang('language.description'):</td>
                    <td>
                        <div class="form-group">
                            <div class="input-icon">
                                <i class="fa fa-user"></i>
                                {!! Form::text('frm[xcategory_desc]', @$list['xcategory_desc'], array('class' => 'form-control'))  !!}
                            </div>
                        </div>
                    </td>
                </tr>

                <tr>
                    <td>@lang('language.display rank'):</td>
                    <td>
                        <div class="form-group">
                            <div class="input-icon">
                                <i class="fa fa-user"></i>
                                {!! Form::text('frm[xrank]', @$list['xrank'], array('class' => 'form-control'))  !!}
                            </div>
                        </div>
                    </td>
                </tr>
                <tr>
                    <td colspan="2">
                        <table class="table table-striped">
                            <tr>
                                <th>@lang('language.picture')</th>
                                <th>@t('menu picture')</th>
                            </tr>
                            <tr>
                                <td>
                                    @include('admin.partial.fileInput', ['exist' => @$imgExist, 'src' => '/pic/category/' . @$list['xcategoryid'] . 'w200h150c1/' . str_random() . '.png?nocache=1', 'action' => 'deleteImg',  'id' => @$list['xcategoryid']])
                                </td>
                                <td>
                                    @include('admin.partial.fileInput', ['exist' => @$menuExist, 'src' => '/pic/category.menu/' . @$list['xcategoryid'] . 'w200h150c1/' . str_random() . '.png?nocache=1', 'action' => 'deleteImg',  'id' => @$list['xcategoryid'], 'name'=>'category/menu', 'type' => 'menu'])
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>
            </table>

            {{-- Warehouse Section List --}}
            <div class="col-md-12 col-xs-12 table-responsive ">
                <h4 class="seperator-title">@t('sub category'): </h4>
                <table class="table table-bordered table-striped">
                     <tr>
                        @if (@$subList)
                            @foreach (@$subList as $key => $sub)
                                @var('j',$key+1)

                                @var('namePrefix','subList[row'.$j.']')
                                @include('backend.templete.imageBox',[
                                    'namePrefix' => $namePrefix,
                                    'list' => $sub,
                                    'fields' => [
                                        ['name'=>'xsubcategoryid', 'title'=>'xsubcategoryid', 'type'=>'hidden', 'class'=>'reset'],
                                        ['name'=>'xsubcategory_name', 'title'=>'title', 'type'=>'text'],
                                        ['name'=>'xsubcategory_desc', 'title'=>'description', 'type'=>'text'],
                                        ['name'=>'xrank', 'title'=>'rank', 'type'=>'number'],
                                    ]
                                ])

                            @endforeach
                        @endif
                        <script>
                            App.normalizeRows('sub-list');
                        </script>
                        <div class="clearfix"></div>
                    </tr>
                </table>
            </div>
        </div>
    </div>
@stop