@section('content')
<div class="col-xs-12 editBook">
    <ul class="nav nav-tabs" role="tablist">
        <li role="presentation" class="active">
            <a href="#home" aria-controls="home" role="tab" data-toggle="tab">اطلاعات عمومی</a>
        </li>
        <li role="presentation">
            <a href="#desc" aria-controls="desc" role="tab" data-toggle="tab">توضیحات</a>
        </li>
        <li role="presentation">
            <a href="#finance" aria-controls="finance" role="tab" data-toggle="tab">اطلاعات مالی</a>
        </li>
        <li role="presentation">
            <a href="#files" aria-controls="files" role="tab" data-toggle="tab">فایل ها</a>
        </li>
    </ul>
    <div class="tab-content">
        <div role="tabpanel" class="tab-pane active" id="home">
            <div class="table-responsive">
            <table class="table table-bordered table-striped">
                <tr>
                    <td>@lang('language.title'):</td>
                    <td>
                        <div class="form-group">
                            <div class="input-icon">
                            <i class="fa fa-th"></i>
                            {!! Form::text('frm[xbook_title]', @$list['xbook_title'], array('class' => 'form-control', ))  !!}
                            </div>
                        </div>
                    </td>
                </tr>

                <tr>
                    <td>@lang('language.subtitle'):</td>
                    <td>
                        <div class="form-group">
                            <div class="input-icon">
                            <i class="fa fa-th"></i>
                            {!! Form::text('frm[xbook_subtitle]', @$list['xbook_subtitle'], array('class' => 'form-control', ))  !!}
                            </div>
                        </div>
                    </td>
                </tr>

                <tr>
                    <td>@t('category'):</td>
                    <td class="form-inline">
                        <div class="form-group w-50">
                            {!! Form::select('', @$categoryList,@$list->category->xcategoryid, ['class' => 'form-control category w-100','data-advancedselect' => 'select2'])  !!}
                        </div>
                        <div class="form-group w-50">
                            {!! Form::select('frm[xsubcategoryid]', [], @$list->xsubcategoryid, ['class' => 'form-control sub-category w-100','data-advancedselect' => 'select2'])  !!}
                        </div>
                    </td>
                </tr>

                <tr>
                    <td>@t('author'):
                        <!-- <br><a class="" href='Author/create/0' title="{{ trans('language.edit') }}"
                            onclick="App.call(this, {'method': 'create', 'id': '0'}, event);">
                            ایجاد مولف جدید
                        </a> -->
                    </td>
                    <td>
                            {!! Form::select('authors[]', @$authorList, @$list->author, ['class' => 'form-control', 'data-advancedselect' => 'select2','multiple'=>"multiple"])  !!}
                    </td>
                </tr>
                <tr>
                    <td>@t('translator'): </td>
                    <td>
                        {!! Form::select('translators[]', @$translatorList, @$list->translator, ['class' => 'form-control', 'data-advancedselect' => 'select2','multiple'=>"multiple"])  !!}
                    </td>
                </tr>

                <tr>
                    <td>@t('publisher'): </td>
                    <td>
                        {!! Form::select('frm[xpublisherid]', @$publisherList, @$list['xpublisherid'], ['class' => 'form-control', 'data-advancedselect' => 'select2'])  !!}
                    </td>
                </tr>
                <tr>
                    <td>@t('quantity'): </td>
                    <td>
                        <div class="form-group">
                            <div class="input-icon">
                            <i class="fa fa-th"></i>
                            {!! Form::text('frm[xbook_quantity]', @$list['xbook_quantity'], array('class' => 'form-control', ))  !!}
                            </div>
                        </div>
                    </td>
                </tr>
                <tr>
                    <td>@t('year'): </td>
                    <td>
                        <div class="form-group">
                            <div class="input-icon">
                            <i class="fa fa-th"></i>
                            {!! Form::text('frm[xbook_year]', @$list['xbook_year'], array('class' => 'form-control', ))  !!}
                            </div>
                        </div>
                    </td>
                </tr>
                <tr>
                    <td>@t('book pages'): </td>
                    <td>
                        <div class="form-group">
                            <div class="input-icon">
                            <i class="fa fa-th"></i>
                            {!! Form::text('frm[xbook_pages]', @$list['xbook_pages'], array('class' => 'form-control', ))  !!}
                            </div>
                        </div>
                    </td>
                </tr>
                <tr>
                    <td>@t('version'): </td>
                    <td>
                        <div class="form-group">
                            <div class="input-icon">
                            <i class="fa fa-th"></i>
                            {!! Form::text('frm[xbook_version]', @$list['xbook_version'], array('class' => 'form-control', ))  !!}
                            </div>
                        </div>
                    </td>
                </tr>
                <tr>
                    <td>ISBN:  </td>
                    <td>
                        <div class="form-group">
                            <div class="input-icon col-xs-10">
                            <i class="fa fa-th"></i>
                            {!! Form::text('frm[xbook_isbn]', @$list['xbook_isbn'], array('class' => 'form-control', 'id'=>'shabakText' ))  !!}

                            </div>
                            <a class="btn btn-primary col-xs-2 js-shabak-reform">تکمیل شابک</a>
                        </div>
                    </td>
                </tr>
                <tr>
                    <td class="frm-title">@t('type'):</td>
                    <td>
                        <div class="form-group">
                            {!! Form::select('frm[xbook_type]', @$typeList, @$list['xbook_type'],
                                ['class' => 'form-control']) !!}
                        </div>
                    </td>
                </tr>

                <tr>
                    <td>@t('tags'): </td>
                    <td>
                        {!! Form::select('tags[]', @$tagList, @$list->tags, ['class' => 'form-control', 'data-advancedselect' => 'select2','data-tags' => 'true', 'multiple'=>"multiple"])  !!}
                        {!! Form::hidden('tagInput',null)!!}
                    </td>
                </tr>

                <tr>
                    <td>@t('status'):</td>
                    <td>
                        <div class="form-group">
                            <div class="input-icon">
                                {!! Form::hidden('frm[xbook_publish]', 0)!!}
                               <label class="el-switch el-switch-green">
                                {!! Form::checkbox('frm[xbook_publish]', 1, @$list['xbook_publish'],array('class'=>'no-checker'))  !!}
                                    <span class="el-switch-style"></span>
                                </label>
                            </div>
                        </div>
                    </td>
                </tr>

                <tr>
                    <td>@lang('language.display rank'): </td>
                    <td>
                        <div class="form-group">
                            <div class="input-icon">
                            <i class="fa fa-th"></i>
                            {!! Form::text('frm[xrank]', @$list['xrank'], array('class' => 'form-control', ))  !!}
                            </div>
                        </div>
                    </td>
                </tr>

                <tr>
                    <td colspan="2">
                        <table class="table table-striped">
                            <tr>
                                <th>@lang('language.picture'): </th>
                            </tr>
                            <tr>
                                <td>
                                    @include('admin.partial.fileInput', ['exist' => @$imgExist, 'src' => '/pic/book/' . @$list['xbookid'] . 'w200h150c1/' . str_random() . '.png?nocache=1', 'action' => 'deleteImg',  'id' => @$list['xbookid']])
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>

                <tr>
                    <td colspan="2">
                        <table class="table table-striped">
                            <tr>
                                <th>@t('digital book file'): </th>
                            </tr>
                            <tr>
                                <td>
                                    {!! Form::file('secure/digitalBook') !!}
                                </td>
                            </tr>
                        </table>
                    </td>
                </tr>
            </table>
            </div>
        </div>
        <div role="tabpanel" class="tab-pane" id="desc">
            <div class="table-responsive">
            <table class="table table-bordered table-striped">
                <tr>
                    <td>@t('abstract'):</td>
                    <td>
                        <div class="form-group">
                            <div class="textarea">

                            {!! Form::textarea('frm[xbook_abstract]', @$list['xbook_abstract'], array('class' => 'form-control textarea_editable', ))  !!}
                            </div>
                        </div>
                    </td>
                </tr>
               <tr>
                    <td>@t('author text'):</td>
                    <td>
                        <div class="form-group">
                            <div class="textarea">

                            {!! Form::textarea('frm[xbook_desc]', @$list['xbook_desc'], array('class' => 'form-control textarea_editable' ))  !!}
                            </div>
                        </div>
                    </td>
                </tr>
                <tr>
                    <td>@t('table of content'):</td>
                    <td>
                        <div class="form-group">
                            <div class="textarea">

                            {!! Form::textarea('frm[xbook_content_table]', @$list['xbook_content_table'], array('class' => 'form-control textarea_editable' ))  !!}
                            </div>
                        </div>
                    </td>
                </tr>
            </table>
            </div>
        </div>
        <div role="tabpanel" class="tab-pane" id="finance">
            <div class="table-responsive">
            <table class="table table-bordered table-striped">
                <tr>
                    <td>@t('hard copy price') (@t('toman')) : </td>
                    <td>
                        <div class="form-group">
                            <div class="input-icon">
                            <i class="fa fa-th"></i>
                            {!! Form::text('frm[xbook_hard_price]', @$list['xbook_hard_price'], array('class' => 'form-control', ))  !!}
                            </div>
                        </div>
                    </td>
                </tr>
                <tr>
                    <td>@t('hard copy price') @t('discount') (@t('toman')) : </td>
                    <td>
                        <div class="form-group">
                            <div class="input-icon">
                            <i class="fa fa-th"></i>
                            {!! Form::text('frm[xbook_hard_discount]', @$list['xbook_hard_discount'], array('class' => 'form-control', ))  !!}
                            </div>
                        </div>
                    </td>
                </tr>
                <tr>
                    <td>@t('digital price') (@t('toman')) : </td>
                    <td>
                        <div class="form-group">
                            <div class="input-icon">
                            <i class="fa fa-th"></i>
                            {!! Form::text('frm[xbook_digital_price]', @$list['xbook_digital_price'], array('class' => 'form-control', ))  !!}
                            </div>
                        </div>
                    </td>
                </tr>
            </table>
            </div>
        </div>

         <div role="tabpanel" class="tab-pane" id="files">
            <div class="table-responsive">
                <div class="form-group">
                    <input type="file" name="files">
                </div>
            </div>
        </div>

    </div>

</div>
    @include('admin.partial.tinymce',['selector' => '.textarea_editable'])
    <script type="text/javascript">
        var subCategory = {!! json_encode($subCategoryList) !!};
        $(document).ready(function(){
            App.setSubGroup(subCategory, 0, $('.editBook select.category'), $('.editBook select.sub-category'),{{@$list['xsubcategoryid']}});
            $(document).on('change','.editBook select.category',function(){
                App.setSubGroup(subCategory, 0, $('.editBook select.category'), $('.editBook select.sub-category'));
            });

            $('.js-shabak-reform').click(function(){
                var code = $('#shabakText').val();
                var shabak = '468964978';
                $('#shabakText').val(shabak+code );
            })
        });

        var attachmentList = {!! (@$attachmentList) ? $attachmentList : "null" !!}
        Custom.fileUploaderInit({{Config('app.id')}},attachmentList);

    </script>
@stop