<?php namespace Modules\Book\Models;

use App\Models\Model;
use DB;

class SubCategory extends Model {
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'xxbook_category_sub';

    /**
     * The primary key for the model.
     *
     * @var string
     */
    protected $primaryKey = 'xsubcategoryid';

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;

    protected $guarded = [];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        'xrank' => 'int',
    ];

    /**
     * Get the category that owns the sub category.
     */
    public function parentCategory() {
        return $this->belongsTo(Category::class, 'xcategoryid');
    }

    /**
     * Get the category that owns the book.
     */
    public function books() {
        return $this->hasMany(Book::class, 'xsubcategoryid');
    }

    /**
     * get Result
     * @param $query
     * @return mixed
     */
    public static function getResult() {
        $instance = new static();

        $res = DB::table($instance->table)
            ->select(['*', "{$instance->primaryKey} AS xid"]);

        return $res;
    }

    public static function getbookCount($id) {
        $instance = new static();
        $res = DB::table('xxbook as b')
            ->leftJoin('xxbook_category_sub as sc', 'b.xsubcategoryid', '=', 'sc.xsubcategoryid')
            ->where('sc.xsubcategoryid', $id)
            ->count();

        return $res;
    }

    public static function updateById($data, $id = 0) {
        $instance = new static();
        return $instance->updateOrCreate([$instance->primaryKey => $id], $data);
    }

    /**
     * delete
     * @param $id
     * @return mixed
     */
    public static function remove($id) {
        $instance = new static();

        $cond = (int) $id ? "{$instance->primaryKey} = '$id'" : $id;

        $res = $instance->newQuery()->whereRaw($cond)->delete();
        return $res;
    }
}