<?php namespace Modules\Book\Models;

use App\Models\Model;
use DB;

class Category extends Model {
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'xxbook_category';

    /**
     * The primary key for the model.
     *
     * @var string
     */
    protected $primaryKey = 'xcategoryid';

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;

    protected $guarded = ['xcategoryid'];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        'xrank' => 'int',
    ];

    /**
     * Get the sub for the category.
     */
    public function subCategory() {
        return $this->hasMany(SubCategory::class, 'xcategoryid');
    }

    /**
     * get Result
     * @param $query
     * @return mixed
     */
    public static function getResult() {
        $instance = new static();
        $res = DB::table($instance->table)
            ->select(array('*', $instance->primaryKey . ' AS xid'));

        return $res;
    }

    public static function getbookCount($id) {
        $instance = new static();
        $res = DB::table('xxbook as b')
            ->leftJoin('xxbook_category_sub as sc', 'b.xsubcategoryid', '=', 'sc.xsubcategoryid')
            ->leftJoin('xxbook_category as c', 'c.xcategoryid', '=', 'sc.xcategoryid')
            ->where('c.xcategoryid', $id)
            ->count();

        return $res;
    }

    public static function updateById($data, $id = 0) {
        $instance = new static();
        return $instance->updateOrCreate([$instance->primaryKey => $id], $data);
    }

    /**
     * delete
     * @param $id
     * @return mixed
     */
    public static function remove($id) {
        $instance = new static();

        if ($id) {
            $subs = $instance->find($id)->subCategory;

            foreach ($subs as $item) {
                parent::deleteFile($item->xsubcategoryid, 'menu');
                $item->delete();
            }

            $res = $instance->destroy($id);
            parent::deleteFile($id);
            die('[[OK]]');
        } else {
            die('[[Error]]');
        }

        return $res;
    }
}