<?php namespace Modules\Book\Models;

use App\Models\Model;
use DB;

class BookQuery extends Model {
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'xxbook_query';

    /**
     * The primary key for the model.
     *
     * @var string
     */
    protected $primaryKey = 'xqueryid';

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;
    public $lang = false;

    protected $guarded = ['xqueryid'];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        'xrank' => 'int',
        'xcount' => 'int',
    ];

    /**
     * get Result
     * @param $query
     * @return mixed
     */
    public static function getResult() {
        $instance = new static();

        $res = DB::table($instance->table . " AS BQ")
            ->leftJoin('xxbook_category_sub AS c', function ($join) {
                // $join->on(DB::raw("find_in_set(c.xsubcategoryid, BQ.xsubcategoryid)", DB::raw(''), DB::raw('')));
                $join->whereRaw("find_in_set(c.xsubcategoryid, BQ.xsubcategoryid)");
            })
            ->leftJoin('xxauthor AS a', 'a.xauthorid', '=', 'BQ.xauthorid')
            ->leftJoin('xxpublisher AS p', 'p.xpublisherid', '=', 'BQ.xpublisherid')
            ->leftJoin('xxtags AS t', 't.xtagid', '=', 'BQ.xtagid')
            ->groupBy('BQ.xqueryid')
            ->select(['*', "{$instance->primaryKey} AS xid", "BQ.xrank AS newRank", DB::raw('GROUP_CONCAT(c.xsubcategory_name ORDER BY c.xsubcategoryid) category_name')]);

        return $res;
    }

    public static function updateById($data, $id = 0) {
        $instance = new static();
        return $instance->updateOrCreate([$instance->primaryKey => $id], $data);
    }

    /**
     * delete
     * @param $id
     * @return mixed
     */
    public static function remove($id) {
        $instance = new static();
        if ($id) {
            $res = $instance->destroy($id);
            die('[[OK]]');
        } else {
            die('[[Error]]');
        }

        return $res;
    }

}