<?php namespace Modules\Book\Models;

use DB;
use stdClass;
use App\Models\Model;
use Modules\Book\Models\Book;

class BookImage extends Model
{
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'xxbook_image';

    /**
     * The primary key for the model.
     *
     * @var string
     */
    protected $primaryKey = 'xbook_imageid';

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;

     /**
     * Get the book that owns the gallery.
     */
    public function book()
    {
        return $this->belongsTo(Book::class);
    }

    /**
     * get Result
     * @param $query
     * @return mixed
     */
    public static function getResult()
    {
        $instance = new static();
        $res = DB::table($instance->table)
            ->select(array('*', $instance->primaryKey . ' AS xid'));

        return $res;
    }

    /**
     * get First
     * @param $id
     * @return mixed
     */
    public static function first($id)
    {
        $instance = new static();
        
        $res = self::getResult()
            ->where($instance->primaryKey, $id)
            ->first();
        return $res;
    }

    /**
     * update or insert
     * @param $data
     * @param int $id
     * @return int
     */
    public static function store($data, $id = 0)
    {
        $instance = new static();
        if (!$id)
            $id = $instance->newQuery()->insertGetId($data);
        else
            $instance->newQuery()->where($instance->primaryKey, intval($id))->update($data);
        
        return $id;
    }

    /**
     * delete
     * @param $id
     * @return mixed
     * @example ModelName::remove(5) | ModelName::remove("xusername = 'test'")
     */
    public static function remove($id)
    {
        $instance = new static();
        $cond = intval($id) != 0 ? "{$instance->primaryKey} = '$id'" : $id;

        $res = $instance->newQuery()->whereRaw($cond)->delete();
        return $res;
    }
}