<?php namespace Modules\Book\Http\Controllers\Index;

use App;
use App\Http\Controllers\IndexController;
use App\Traits\UploadMultiFile;
use Auth;
use Input;
use Modules\Book\Models\Book;
use Modules\Book\Models\BookImage;
use Modules\Book\Models\BookQuery;
use Modules\Book\Models\Category;
use Modules\Book\Models\SubCategory;
use Modules\Home\Models\Tag;
use Redirect;
use Request;
use Str;

class BookRequestController extends IndexController {
    /*
    |--------------------------------------------------------------------------
    | Home Controller
    |--------------------------------------------------------------------------
    |
    | This controller renders your application's "dashboard" for users that
    | are authenticated. Of course, you are free to change or remove the
    | controller as you wish. It is just here to get your app started!
    |
     */

    /**
     * Show the application dashboard to the user.
     *
     * @return Response
     */
    public function index() {
        $breadcrumb[] = ['title' => 'پذیرش اثر', 'href' => ''];
        $this->layout->breadcrumb = $breadcrumb;

        $this->layout->title = 'پذیرش اثر';
        $this->layout->content = view('book::index.request.index', [
            'title' => 'پذیرش اثر',
        ]);
    }

    public function authorForm() {
        $breadcrumb[] = ['title' => 'پذیرش اثر', 'href' => ''];
        $this->layout->breadcrumb = $breadcrumb;

        $this->layout->title = 'پذیرش اثر';
        $this->layout->content = view('book::index.request.authorForm', [
            'title' => 'پذیرش اثر',
        ]);
    }

    public function category($id, $title = null) {
        $category = Category::find($id);
        $breadcrumb[] = ['title' => t('book'), 'href' => ''];
        $breadcrumb[] = ['title' => $category->xcategory_name, 'href' => ''];
        $this->layout->breadcrumb = $breadcrumb;
        $this->layout->title = t('book');
        $this->layout->content = view('book::index.category', [
            'category' => $category,
        ]);

    }


    public function detail($id, $title = null) {
        $fieldPostFix = (App::getLocale() == 'en') ? '_en' : ((App::getLocale() == 'ar') ? '_ar' : '');

        $book = Book::find($id);
        $gallery = BookImage::find($id);
        $categoryBooks = Book::where('xsubcategoryid', $book->xsubcategoryid)
            ->where('xbook_publish',1)
            ->orderBy('xbook_sell_count', 'desc')
            ->orderBy('xrank', 'desc')
            ->take(7)
            ->get();
        $comments = $book->comments()->where('xcomment_approved', 1)->get();

        $breadcrumb[] = ['title' => t('book'), 'href' => ''];
        if(@$book->category)
            $breadcrumb[] = ['title' => @$book->category->xsubcategory_name, 'href' => 'Book/subCategory/' . @$book->category->xsubcategoryid];
        $breadcrumb[] = ['title' => $book->xbook_title, 'href' => ''];

        $attachmentList = self::attachmentFiles($id);

        $this->layout->breadcrumb = $breadcrumb;
        $this->layout->title2 = $book->xbook_title;
        $this->layout->description = Str::words($book->xbook_abstract, 40);
        $this->layout->ogImage = 'http://cppc.ir/pic/book/' . $book->xbookid . 'w135h200c1/' . $book->xbookid . '.jpg';
        $this->layout->content = view('book::index.detail', [
            'book' => $book,
            'gallery' => $gallery,
            'categoryBooks' => $categoryBooks,
            'comments' => $comments,
            'attachmentList' => $attachmentList,
        ]);
    }

}
