<?php namespace Modules\Book\Http\Controllers\Index;

use App;
use App\Http\Controllers\IndexController;
use App\Traits\UploadMultiFile;
use Auth;
use Input;
use Modules\Book\Models\Book;
use Modules\Book\Models\BookImage;
use Modules\Book\Models\BookQuery;
use Modules\Book\Models\Category;
use Modules\Book\Models\SubCategory;
use Modules\Home\Models\Tag;
use Redirect;
use Request;
use Str;

class BookController extends IndexController {
    use UploadMultiFile;
    /*
    |--------------------------------------------------------------------------
    | Home Controller
    |--------------------------------------------------------------------------
    |
    | This controller renders your application's "dashboard" for users that
    | are authenticated. Of course, you are free to change or remove the
    | controller as you wish. It is just here to get your app started!
    |
     */

    /**
     * Show the application dashboard to the user.
     *
     * @return Response
     */
    public function index() {
        $sort = 'xproduct_rank';
        $orderby = 'desc';
        $cat = SubCategory::get();

        $breadcrumb[] = ['title' => t('book'), 'href' => ''];
        $this->layout->breadcrumb = $breadcrumb;

        $this->layout->title = t('book');
        $this->layout->content = view('book::index.widget.categoryList', [
            'list' => $cat,
            'title' => 'دسته بندی کتب',
        ]);
    }

    public function category($id, $title = null) {
        $category = Category::find($id);
        $breadcrumb[] = ['title' => t('book'), 'href' => ''];
        $breadcrumb[] = ['title' => $category->xcategory_name, 'href' => ''];
        $this->layout->breadcrumb = $breadcrumb;
        $this->layout->title = t('book');
        $this->layout->content = view('book::index.category', [
            'category' => $category,
        ]);

    }

    public function subCategory($id, $title = null) {
        $category = SubCategory::find($id);
        $breadcrumb[] = ['title' => t('book'), 'href' => ''];
        $breadcrumb[] = ['title' => $category->xsubcategory_name, 'href' => ''];
        $this->layout->breadcrumb = $breadcrumb;
        $this->layout->title = t('book');
        $this->layout->content = view('book::index.subCategory', [
            'category' => $category,
        ]);

    }

    public function query($id) {
        $queryBook = BookQuery::find($id);
        if ($queryBook) {
            $books = Book::with(['author', 'publisher'])->where('xbook_publish', 1)->where('xbook_editedid', null)
                ->when($queryBook['xsubcategoryid'], function ($query, $data) {
                    return $query->whereIn('xsubcategoryid', explode(',', $data));
                })
                ->when($queryBook['xpublisherid'], function ($query, $data) {
                    return $query->where('xpublisherid', $data);
                })
                ->when($queryBook['xauthorid'], function ($query, $data) {
                    return $query->where('xauthorid', $data);
                })
                ->when($queryBook['xtagid'], function ($query, $data) {
                    $tag = Tag::find($data);
                    return $query->whereIn('xbookid', $tag->books->pluck('xbookid'));
                })
                ->when($queryBook['xsortby'], function ($query, $data) {
                    return $query->orderBy($data, 'desc');
                });

        }

        $breadcrumb[] = ['title' => t('book'), 'href' => ''];
        $breadcrumb[] = ['title' => $queryBook->xtitle, 'href' => ''];
        $this->layout->breadcrumb = $breadcrumb;
        $this->layout->title = t('book');
        $books = $books->paginate(30)->withPath(Request::url());
        $this->layout->content = view('book::index.bookList', [
            'books' => $books,
            'title' => $queryBook->xtitle,
        ]);
    }

    public function detail($id, $title = null) {
        $fieldPostFix = (App::getLocale() == 'en') ? '_en' : ((App::getLocale() == 'ar') ? '_ar' : '');

        $book = Book::find($id);
        $gallery = BookImage::find($id);
        $categoryBooks = Book::where('xsubcategoryid', $book->xsubcategoryid)
            ->where('xbook_publish',1)
            ->orderBy('xbook_sell_count', 'desc')
            ->orderBy('xrank', 'desc')
            ->take(7)
            ->get();
        $comments = $book->comments()->where('xcomment_approved', 1)->get();

        $breadcrumb[] = ['title' => t('book'), 'href' => ''];
        if(@$book->category)
            $breadcrumb[] = ['title' => @$book->category->xsubcategory_name, 'href' => 'Book/subCategory/' . @$book->category->xsubcategoryid];
        $breadcrumb[] = ['title' => $book->xbook_title, 'href' => ''];

        $attachmentList = self::attachmentFiles($id);

        $this->layout->breadcrumb = $breadcrumb;
        $this->layout->title2 = $book->xbook_title;
        $this->layout->description = Str::words($book->xbook_abstract, 40);
        $this->layout->ogImage = 'http://cppc.ir/pic/book/' . $book->xbookid . 'w135h200c1/' . $book->xbookid . '.jpg';
        $this->layout->content = view('book::index.detail', [
            'book' => $book,
            'gallery' => $gallery,
            'categoryBooks' => $categoryBooks,
            'comments' => $comments,
            'attachmentList' => $attachmentList,
        ]);
    }

    public function addComment() {
        $user = Auth::user();
        if ($user) {
            $comment = Input::get('commentDesc');
            $book = Book::find(Input::get('bookid'));
            $book->comments()->create([
                'xuserid' => $user->xuserid,
                'xcomment_content' => $comment,
            ]);
            return Redirect::back()->with('commentStatus', 'success');
        } else {
            return redirect('User/login');
        }
        return Redirect::back()->with('commentStatus', 'failed');
    }

    public function shabak($id) {
        $book = Book::where('xbook_isbn', $id)->first();
        if (!$book) {
            return redirect('/');
        }
        $id = $book->xbookid;
        $url = "/Book/Detail/{$id}";
        return redirect($url);
    }
}
