<?php namespace Modules\Book\Http\Controllers\Admin;

use App\Http\Controllers\BackendController;
use App\Traits\UploadMultiFile;
use Auth;
use File;
use Input;
use Modules\Author\Models\Author;
use Modules\Book\Models\Book;
use Modules\Book\Models\Category;
use Modules\Book\Models\SubCategory;
use Modules\Home\Models\Tag;
use Modules\Publisher\Models\Publisher;

class EditedBookController extends BackendController {
    use UploadMultiFile;
    public $title = "book edited";

    //## list
    //Str::words($item["xvideo_desc"],25);
    //FarsiLib::faNormalizeNumber($item["xevent_price"])
    //FarsiLib::g2jDate($item["xstart"],true);
    //FarsiLib::g2jDate(date('m/d/Y H:i:s',@$list->xcomment_date),true)
    //FarsiLib::j2gDate() convert input from form
    public function index() {

        $this->field[] = array('php' => 'echo \'<div style="text-align: center;"><img src="/pic/book/\' . $item["xbookid"] . "w100h110c1/". str_random() . ".png?nocache=1" . \'" alt="" /></div>\';',
            'name' => trans('language.picture'), 'css' => 'width: 3%');
        $this->field[] = array('php' => 'echo $item["xbook_title"];', 'name' => @t('title'), 'css' => 'width: 10%', 'sortable' => 'xbook_title');

        $this->field[] = array('php' => 'echo $item["xpublisher_name"];', 'name' => @t('publisher'), 'css' => 'width: 10%', 'sortable' => 'xpublisherid');

        $this->field[] = array('php' => 'echo $item["xbook_quantity"];', 'name' => @t('quantity'), 'css' => 'width: 10%', 'sortable' => 'xbook_quantity');

        $this->field[] = array('php' => 'echo $item["xbook_editeduserid"];', 'name' => @t('language.user'), 'css' => 'width: 10%', 'sortable' => 'xbook_editeduserid');
        $this->field[] = array('php' => 'echo FarsiLib::g2jDate($item["xbook_editeddate"],true);', 'name' => @t('language.date'), 'css' => 'width: 10%', 'sortable' => 'xbook_editeddate');

        $this->field[] = array('php' => 'echo $item["xrank"];', 'name' => trans('language.display rank'), 'css' => 'width: 10%', 'sortable' => 'xrank');

        $this->list = Book::getResult()->whereNotNull('xbook_editedid');

        $this->paginate();

    }

    //## new
    public function create($id = 0) {
        $this->layout->title = $this->title;
    }

    //## edit
    public function edit($id) {
        $this->layout->content = view('book::admin.edit.book');
        $this->layout->content->list = Book::find($id);
        $this->layout->content->imgExist = File::exists(config('upload.Book') . "/$id");
        $this->layout->title = $this->title;
        $this->layout->content->attachmentList = json_encode(self::attachmentFiles($id));
        self::setCombo();
    }

    //## store
    public function store($id) {
        $frm = Input::get('frm');
        $authors = Input::get('authors');
        $translators = Input::get('translators');
        $tags = Input::get('tags');
        $newTags = Input::get('tagInput');
        $filesList = Input::get('filesUpload', []);
        $user = Auth::user();

        if (!$user->roles->contains(function ($item) {
            return in_array($item->xroleid, config('book.approvechange'));
        })) {
            die('[[ERROR]]');
        }
        $newbook = Book::find($id);
        $book = Book::updateById($frm, $newbook->xbook_editedid);
        $book->author()->detach();
        if ($authors) {
            foreach ($authors as $key => $value) {
                $book->author()->attach($value);
            }
        }

        $book->translator()->detach();
        if ($translators) {
            foreach ($translators as $key => $value) {
                $book->translator()->attach($value);
            }
        }

        $book->tags()->detach();
        $newTags = explode(',,', $newTags);
        if ($tags) {
            foreach ($tags as $key => $value) {
                if (!in_array($value, $newTags)) {
                    $book->tags()->attach($value);
                } else {
                    $book->tags()->create(['xname' => $value]);
                }

            }
        }

        self::storeAttachmentFiles($book->xbookid, $filesList);
        $this->saveFile($book->xbookid);
        $newbook->delete();
        die('[[OK]]');

    }

    //## delete
    public function delete($id) {
        Book::remove($id);

    }

    //## delete Image
    public function deleteImage($id) {
        File::delete(config('upload.Book') . "/$id");
        die('[[OK]]');
    }

    //## set combo
    public function setCombo() {
        // $provinceList = Province::getResult()->lists('xprovince_name','xprovinceid');
        // $this->layout->provinceList = $this->layout->content->provinceList = $provinceList;

        $this->layout->authorList = $this->layout->content->authorList = Author::pluck('xauthor_name', 'xauthorid')->prepend('', '');
        $this->layout->translatorList = $this->layout->content->translatorList = Author::where('xauthor_istranslator', 1)->pluck('xauthor_name', 'xauthorid')->prepend('', '');
        $this->layout->publisherList = $this->layout->content->publisherList = Publisher::pluck('xpublisher_name', 'xpublisherid')->prepend('', '');

        $this->layout->categoryList = $this->layout->content->categoryList = Category::pluck('xcategory_name', 'xcategoryid')->prepend('', '');

        $this->layout->tagList = $this->layout->content->tagList = Tag::pluck('xname', 'xtagid');

        $subCategory = SubCategory::all();
        $subCategoryList = [];
        foreach (@$subCategory as $key => $val) {
            if (!@$subCategoryList[@$val['xcategoryid']]) {
                $subCategoryList[@$val['xcategoryid']][''] = '';
            }

            $subCategoryList[@$val['xcategoryid']][@$val['xsubcategory_name']] = @$val['xsubcategoryid'];
        }
        $this->layout->subCategoryList = $this->layout->content->subCategoryList = $subCategoryList;

        $this->layout->typeList = $this->layout->content->typeList = Book::fetchEnum('xbook_type');

    }

}