<?php namespace Modules\Book\Http\Controllers\Admin;

use App\Http\Controllers\BackendController;
use Input;
use Modules\Author\Models\Author;
use Modules\Book\Models\BookQuery;
use Modules\Book\Models\Category;
use Modules\Book\Models\SubCategory;
use Modules\Home\Models\Tag;
use Modules\Publisher\Models\Publisher;

class BookQueryController extends BackendController {
    public $title = "book query";

    //## list
    //Str::words($item["xvideo_desc"],25);
    //FarsiLib::faNormalizeNumber($item["xevent_price"])
    //FarsiLib::g2jDate($item["xstart"],true);
    //FarsiLib::g2jDate(date('m/d/Y H:i:s',@$list->xcomment_date),true)
    //FarsiLib::j2gDate() convert input from form
    public function index() {

        $this->field[] = array('php' => 'echo $item["xtitle"];', 'name' => @t('name'), 'css' => 'width: 10%', 'sortable' => 'xtitle');

        $this->field[] = array('php' => 'echo $item["category_name"];', 'name' => @t('category'), 'css' => 'width: 10%');
        $this->field[] = array('php' => 'echo $item["xpublisher_name"];', 'name' => @t('publisher'), 'css' => 'width: 10%', 'sortable' => 'xpublisher_name');
        $this->field[] = array('php' => 'echo $item["xauthor_name"];', 'name' => @t('author'), 'css' => 'width: 10%', 'sortable' => 'xauthor_name');
        $this->field[] = array('php' => 'echo $item["xname"];', 'name' => @t('tag'), 'css' => 'width: 10%', 'sortable' => 'xname');

        $this->field[] = array('php' => 'echo $item["xsortby"];', 'name' => @t('sort'), 'css' => 'width: 10%', 'sortable' => 'xsortby');
        $this->field[] = array('php' => 'echo $item["xcount"];', 'name' => @t('count'), 'css' => 'width: 10%', 'sortable' => 'xcount');
        $this->field[] = array('php' => 'echo $item["xplace"];', 'name' => @t('place'), 'css' => 'width: 10%', 'sortable' => 'xplace');

        $this->field[] = array('php' => 'echo $item["newRank"];', 'name' => trans('language.display rank'), 'css' => 'width: 10%', 'sortable' => 'BQ.xrank');

        $this->list = BookQuery::getResult();

        $this->paginate();

    }

    //## new
    public function create($id = 0) {
        $this->layout->title = $this->title;
    }

    //## edit
    public function edit($id) {
        $this->layout->content->list = BookQuery::find($id);
        $this->layout->title = $this->title;
    }

    //## store
    public function store($id) {
        $frm = Input::get('frm');
        $frm['xsubcategoryid'] = @$frm['xsubcategoryid'] ? implode(',', $frm['xsubcategoryid']) : null;
        $book = BookQuery::updateById($frm, $id);
        die('[[OK]]');

    }

    //## delete
    public function delete($id) {
        BookQuery::remove($id);

    }

    //## set combo
    public function setCombo() {
        $this->layout->locationList = $this->layout->content->locationList = BookQuery::fetchEnum('xplace');
        $this->layout->publisherList = $this->layout->content->publisherList = Publisher::pluck('xpublisher_name', 'xpublisherid')->prepend('', '');
        $this->layout->authorList = $this->layout->content->authorList = Author::pluck('xauthor_name', 'xauthorid')->prepend('', '');
        $this->layout->subcategoryList = $this->layout->content->subcategoryList = SubCategory::pluck('xsubcategory_name', 'xsubcategoryid')->prepend('', '');
        $this->layout->tagList = $this->layout->content->tagList = Tag::pluck('xname', 'xtagid')->prepend('', '');

        $this->layout->categoryList = $this->layout->content->categoryList = Category::pluck('xcategory_name', 'xcategoryid')->prepend('', '');

        $this->layout->sortList = $this->layout->content->sortList = [
            'xrank' => 'اولویت',
            'xbook_sell_count' => 'پرفروش ترین',
            'created_at' => 'جدیدترین',
        ];
    }

}