<?php namespace Modules\Book\Http\Controllers\Admin;

use App\Http\Controllers\BackendController;
use App\Traits\UploadMultiFile;
use Auth;
use Carbon\Carbon;
use Config;
use File;
use Input;
use Modules\Author\Models\Author;
use Modules\Book\Exports\BooksExport;
use Modules\Book\Models\Book;
use Modules\Book\Models\BookImage;
use Modules\Book\Models\Category;
use Modules\Book\Models\SubCategory;
use Modules\Home\Models\Tag;
use Modules\Publisher\Models\Publisher;

class BookController extends BackendController {
    use UploadMultiFile;

    public $title = "book";

    //## list
    public function index() {
        $this->field[] = array('php' => 'echo \'<div style="text-align: center;"><img src="/pic/book/\' . $item["xbookid"] . "w100h110c1/". str_random() . ".png?nocache=1" . \'" alt="" /></div>\';',
            'name' => trans('language.picture'), 'css' => 'width: 3%');
        $this->field[] = array('php' => 'echo $item["xbook_title"];', 'name' => @t('title'), 'css' => 'width: 10%', 'sortable' => 'xbook_title');

        $this->field[] = array('php' => 'echo $item["xpublisher_name"];', 'name' => @t('publisher'), 'css' => 'width: 10%', 'sortable' => 'xpublisherid');

        $this->field[] = array('php' => 'echo $item["xbook_quantity"];', 'name' => @t('quantity'), 'css' => 'width: 10%', 'sortable' => 'xbook_quantity');

        $this->field[] = array('php' => 'echo $item["xrank"];', 'name' => trans('language.display rank'), 'css' => 'width: 10%', 'sortable' => 'xrank');

        $this->list = Book::getResult()->whereNull('xbook_editedid');

        $this->paginate();
        $this->layout->content->listBtn['showProductGallery'] = true;
        $this->layout->toolbar['showTools'] = true;
        $this->layout->content->listBtn['showCheckbox'] = true;
        //$this->layout->content->listBtn['showBookContent'] = true;
    }

    //## new
    public function create($id = 0) {
        $this->layout->title = $this->title;
    }

    //## edit
    public function edit($id) {
        $this->layout->content->list = Book::find($id);
        $this->layout->content->imgExist = File::exists(config('upload.' . config('app.controller')) . "/$id");
        $this->layout->title = $this->title;
        $this->layout->content->attachmentList = json_encode(self::attachmentFiles($id));

    }

    //## store
    public function store($id) {
        $frm = Input::get('frm');
        $authors = Input::get('authors');
        $translators = Input::get('translators');
        $tags = Input::get('tags');
        $newTags = Input::get('tagInput');
        $filesList = Input::get('filesUpload', []);
        $user = Auth::user();

        if ($user->roles->contains(function ($item) {
            return in_array($item->xroleid, config('book.approvechange'));
        })) {
            $book = Book::updateById($frm, $id);
        } else {
            $frm['xbook_editedid'] = $id;
            $frm['xbook_editeduserid'] = $user->xuserid;
            $frm['xbook_editeddate'] = Carbon::now();
            $frm['xbook_publish'] = 0;
            $book = Book::updateById($frm);
        }

        $book->author()->detach();
        if ($authors) {
            foreach ($authors as $key => $value) {
                $book->author()->attach($value);
            }
        }

        $book->translator()->detach();
        if ($translators) {
            foreach ($translators as $key => $value) {
                $book->translator()->attach($value);
            }
        }

        $book->tags()->detach();
        $newTags = explode(',,', $newTags);
        if ($tags) {
            foreach ($tags as $key => $value) {
                if (!in_array($value, $newTags)) {
                    $book->tags()->attach($value);
                } else {
                    $book->tags()->create(['xname' => $value]);
                }

            }
        }

        self::storeAttachmentFiles($book->xbookid, $filesList);

        $this->saveFile($book->xbookid);
        die('[[OK]]');

    }

    //## delete
    public function delete($id) {
        Book::remove($id);

    }

    //## delete Image
    public function deleteImage($id) {
        File::delete(config('upload.' . config('app.controller')) . "/$id");
        die('[[OK]]');
    }

    //## set combo
    public function setCombo() {
        // $provinceList = Province::getResult()->lists('xprovince_name','xprovinceid');
        // $this->layout->provinceList = $this->layout->content->provinceList = $provinceList;

        $this->layout->authorList = $this->layout->content->authorList = Author::pluck('xauthor_name', 'xauthorid')->prepend('', '');
        $this->layout->translatorList = $this->layout->content->translatorList = Author::where('xauthor_istranslator', 1)->pluck('xauthor_name', 'xauthorid')->prepend('', '');
        $this->layout->publisherList = $this->layout->content->publisherList = Publisher::pluck('xpublisher_name', 'xpublisherid')->prepend('', '');

        $this->layout->categoryList = $this->layout->content->categoryList = Category::pluck('xcategory_name', 'xcategoryid')->prepend('', '');

        $this->layout->tagList = $this->layout->content->tagList = Tag::pluck('xname', 'xtagid');

        $subCategory = SubCategory::all();
        $subCategoryList = [];
        foreach (@$subCategory as $key => $val) {
            if (!@$subCategoryList[@$val['xcategoryid']]) {
                $subCategoryList[@$val['xcategoryid']][''] = '';
            }

            $subCategoryList[@$val['xcategoryid']][@$val['xsubcategory_name']] = @$val['xsubcategoryid'];
        }
        $this->layout->subCategoryList = $this->layout->content->subCategoryList = $subCategoryList;

        $this->layout->typeList = $this->layout->content->typeList = Book::fetchEnum('xbook_type');

    }

    public function editProductGallery($id) {
        $this->layout->storeMethod = 'storeProductGallery';
        $this->layout->content = view('book::admin.edit.bookImage');

        $galleryList = Book::find($id)->images->toArray();
        $this->layout->content->galleryList = $galleryList ?: [1];
        $this->layout->content->imageExist = File::exists(Config::get('upload.' . Config::get('app.controller')) . "/$id");
        foreach ($galleryList as $gallery) {
            $this->layout->content->galleryExist[$gallery['xbook_imageid']] = File::exists(Config::get('upload.' . Config::get('app.controller')) . "/gallery/" . $gallery['xbook_imageid']);
        }
        $this->layout->title = '';
    }

    public function storeProductGallery($id) {
        $frm = Input::get('frm');
        $galleryList = Input::get('galleryList');
        $galleryImg = [];
        if ($galleryList) {
            foreach ($galleryList as $key => $gallery) {
                $gallery['xproductid'] = $id;
                $galleryid = BookImage::store($gallery, $gallery['xbook_imageid']);
                $galleryImg[$key] = $galleryid;
            }
        }

        $this->saveFile($id, $galleryImg);

        die('[[OK]]');
    }

    public function deleteProductGallery($id) {
        if ($id) {
            $res = BookImage::remove($id);
            if (!$res) {
                alert(trans('language.this record can not be removed'));
                die('[[Error]]');
            } else {
                File::delete(Config::get('upload.' . Config::get('app.controller')) . "/gallery/$id");
                die('[[OK]]');
            }
        } else {
            die('[[Error]]');
        }
    }

    public function editBookContent($id) {
        $this->layout->storeMethod = 'storeBookContent';
        $this->layout->content = view('book::admin.edit.bookContent');

        $content = Book::find($id)->xbook_content;
        $this->layout->content->bookContent = $content;

        $this->layout->title = '';
    }

    public function excelExport() {
        $checkall = Input::get('checkall');
        $listchk = Input::get('listchk');

        $this->list = Book::getResult();
        if (!$checkall && $listchk) {
            $this->list->whereIn('xbookid', array_keys($listchk));
        }
        $this->setQueryToList();

        if (!$this->list->orders) {
            $this->list->orders = [[
                "column" => "xbookid",
                "direction" => "desc",
            ]];
        }

        return (new BooksExport($this->list))->download('books.xlsx');
    }

}