<?php namespace Modules\Book\Http\Controllers\Admin;

use App\Http\Controllers\BackendController;
use Input;
use Modules\Book\Models\Book;
use Modules\Book\Models\BookAdvertise;

class BookAdvertiseController extends BackendController {
    public $title = "book advertise";

    //## list
    //Str::words($item["xvideo_desc"],25);
    //FarsiLib::faNormalizeNumber($item["xevent_price"])
    //FarsiLib::g2jDate($item["xstart"],true);
    //FarsiLib::g2jDate(date('m/d/Y H:i:s',@$list->xcomment_date),true)
    //FarsiLib::j2gDate() convert input from form
    public function index() {

        $this->field[] = array('php' => 'echo $item["xbookid"];', 'name' => trans('language.id'), 'css' => 'width: 10%', 'sortable' => 'xbookid');

        $this->field[] = array('php' => 'echo FarsiLib::g2jDate($item["xstart"],true);', 'name' => @t('start'), 'css' => 'width: 10%', 'sortable' => 'xstart');

        $this->field[] = array('php' => 'echo FarsiLib::g2jDate($item["xend"],true);', 'name' => @t('end'), 'css' => 'width: 10%', 'sortable' => 'xend');

        $this->field[] = array('php' => 'echo $item["xrank"];', 'name' => trans('language.display rank'), 'css' => 'width: 10%', 'sortable' => 'xrank');

        $this->list = BookAdvertise::getResult();

        $this->paginate();

    }

    //## new
    public function create($id = 0) {
        $this->layout->title = $this->title;
    }

    //## edit
    public function edit($id) {
        $this->layout->content->list = BookAdvertise::find($id);
        $this->layout->title = $this->title;
    }

    //## store
    public function store($id) {
        $frm = Input::get('frm');
        $adv = BookAdvertise::updateById($frm, $id);
        die('[[OK]]');

    }

    //## delete
    public function delete($id) {
        Advertise::remove($id);

    }

    //## set combo
    public function setCombo() {
        $this->layout->bookList = $this->layout->content->bookList = Book::pluck('xbook_title', 'xbookid')->prepend('', '');

    }

}