<?php

namespace Modules\Book\Exports;

use Maatwebsite\Excel\Concerns\Exportable;
use Maatwebsite\Excel\Concerns\FromQuery;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Modules\Book\Models\Book;

class BooksExport implements FromQuery, WithHeadings {
    use Exportable;

    public function __construct($query) {
        $this->query = $query;
    }

    public function headings(): array
    {
        return [
            'شناسه',
            'شناسه ناشر',
            'شناسه دسته بندی',
            'عنوان کتاب',
            'زیر عنوان کتاب',
            'سخن مولف',
            'چکیده',
            'فهرست موضوعات',
            'قیمت نسخه چاپی',
            'تخفیف نسخه چاپی',
            'قیمت نسخه دیجیتال',
            'سال تولید',
            'تعداد صفحات',
            'تعداد فروش',
            'تعداد موجودی',
            'شابک',
            'زبان کتاب',
            'نوع چاپ',
            'اولویت',
            'زبان',
            'نوع',
            'وضعیت انتشار',
            'زمان تولید',
        ];
    }

    public function query() {
        return $this->query;
    }
}