@section('content')
<div class="col-md-12">
    <div class="table-responsive">
        <table class="table table-bordered table-striped">
            <tr>
                <td>@t('articlegroup'):</td>
                <td>
                    <div class="form-group">
                        <div class="input-icon">

                            {!! Form::select('frm[xarticlegroupid]', @$groupList, @$list['xarticlegroupid'], ['class' =>
                            'form-control', 'data-advancedselect' => 'select2']) !!}
                        </div>
                    </div>
                </td>
            </tr>
            <tr>
                <td>@lang('language.title'):</td>
                <td>
                    <div class="form-group">
                        <div class="input-icon">
                            <i class="fa fa-th"></i>
                            {!! Form::text('frm[xarticle_title]', @$list['xarticle_title'], array('class' =>
                            'form-control')) !!}
                        </div>
                    </div>
                </td>
            </tr>
            <tr>
                <td>@lang('language.link'):</td>
                <td>
                    <div class="form-group">
                        <div class="input-icon">
                            <i class="fa fa-th"></i>
                            <input class="form-control" name="frm[url]" type="text"
                                value="{{ @$list['url'] }}" aria-invalid="false">
                        </div>
                    </div>
                </td>
            </tr>
            <tr>
                <td> @lang('language.link') @t('redirect'):</td>
                <td>
                    <div class="form-group">
                        <div class="input-icon">
                        <i class="fa fa-th"></i>
                        {!! Form::text('frm[redirect_url]', @$list['redirect_url'], array('class' => 'form-control', ))  !!}
                        </div>
                    </div>
                </td>
            </tr>
            <tr>
                <td>@t('duration'):</td>
                <td>
                    <div class="form-group">
                        <div class="input-icon">
                            <i class="fa fa-th"></i>
                            {!! Form::text('frm[xarticle_duration]', @$list['xarticle_duration'], array('class' =>
                            'form-control')) !!}
                        </div>
                    </div>
                </td>
            </tr>
            <tr>
                <td>@t('abstract'):</td>
                <td>
                    <div class="form-group">
                        <div class="textarea">
                            <textarea name="frm[xarticle_abstract]" style="width:100%"
                                rows="4">{{ @$list['xarticle_abstract'] }}</textarea>
                        </div>
                    </div>
                </td>
            </tr>
            <tr>
                <td colspan="2">
                    @t('description'):
                        <div class="form-group">
                            <div class="textarea">
                                <textarea class="tinymce_editor"
                                    name="frm[xarticle_desc]">{{ @$list['xarticle_desc'] }}</textarea>
                            </div>
                        </div>
                </td>
            </tr>
            <tr>
                <td>@t('tags'): </td>
                <td>
                    {!! Form::select('tags[]', @$tagList, @$list->tags, ['class' => 'form-control',
                    'data-advancedselect' => 'select2','data-tags' => 'true', 'multiple'=>"multiple"]) !!}
                    {!! Form::hidden('tagInput',null)!!}
                </td>
            </tr>
            <tr>
                <td>@lang('language.display rank'):</td>
                <td>
                    <div class="form-group">
                        <div class="input-icon">
                            <i class="fa fa-user"></i>
                            {!! Form::text('frm[xrank]', @$list['xrank'], array('class' => 'form-control')) !!}
                        </div>
                    </div>
                </td>
            </tr>
            <tr>
                <td>@t('seo title'):</td>
                <td>
                    <div class="form-group">
                        <div class="input-icon">
                            <i class="fa fa-user"></i>
                            {!! Form::text('frm[seo_title]', @$list['seo_title'], array('class' => 'form-control')) !!}
                        </div>
                    </div>
                </td>
            </tr>
            <tr>
                <td>@t('seo description'):</td>
                <td>
                    <div class="form-group">
                        <div class="input-icon">
                            <i class="fa fa-user"></i>
                            {!! Form::text('frm[seo_description]', @$list['seo_description'], array('class' =>
                            'form-control')) !!}
                        </div>
                    </div>
                </td>
            </tr>

            <tr>
                <td>@t('seo canonical'):</td>
                <td>
                    <div class="form-group">
                        <div class="input-icon">
                            <i class="fa fa-user"></i>
                            {!! Form::text('frm[seo_canonical]', @$list['seo_canonical'], array('class' =>
                            'form-control')) !!}
                        </div>
                    </div>
                </td>
            </tr>
            <tr>
                        <td>@t('tag') @t('noindex'):</td>
                        <td>
                            <div class="form-group">
                                <div class="input-icon">
                                    {!! Form::hidden('frm[seo_noindex]', 0)!!}
                                <label class="el-switch el-switch-green">
                                    {!! Form::checkbox('frm[seo_noindex]', 1, @$list['seo_noindex'],array('class'=>'no-checker'))  !!}
                                        <span class="el-switch-style"></span>
                                    </label>
                                </div>
                            </div>
                        </td>
                    </tr>
            <tr>
                <td>@t('show in top article'):</td>
                <td>
                    <div class="form-group">
                        <div class="input-icon">
                            {!! Form::hidden('frm[xarticle_top]', 0)!!}
                            <label class="el-switch el-switch-green">
                                {!! Form::checkbox('frm[xarticle_top]', 1,
                                @$list['xarticle_top'],array('class'=>'no-checker')) !!}
                                <span class="el-switch-style"></span>
                            </label>
                        </div>
                    </div>
                </td>
            </tr>
            <tr>
                <td>@t('author'):</td>
                <td>
                    <div class="form-group">
                        <div class="input-icon">

                            {!! Form::select('frm[xuserid]', @$userList, @$list['xuserid'], ['class' => 'form-control',
                            'data-advancedselect' => 'select2']) !!}
                        </div>
                    </div>
                </td>
            </tr>
            <tr>
                <td>@t('publish'):</td>
                <td>
                    <div class="form-group">
                        <div class="input-icon">
                            {!! Form::hidden('frm[xstatus]', 0)!!}
                            <label class="el-switch el-switch-green">
                                {!! Form::checkbox('frm[xstatus]', 1, @$list['xstatus'],array('class'=>'no-checker'))
                                !!}
                                <span class="el-switch-style"></span>
                            </label>
                        </div>
                    </div>
                </td>
            </tr>

            <tr>
                <td colspan="2">
                    <table class="table ">
                        <tr>
                            <th>@lang('language.picture')</th>
                            <th>@t('banner')</th>
                        </tr>
                        <tr>
                            <td>
                                @include('admin.partial.fileInput', ['exist' => @$imgExist, 'src' => '/pic/article.image/' . @$list['xarticleid'] . 'w200h150c1/' . str_random() . '.png?nocache=1', 'action' => 'deleteImg',  'id' => @$list['xarticleid'], 'name'=>'article/image', 'type' => 'image'])
                            </td>
                            <td>
                                @include('admin.partial.fileInput', ['exist' => @$bannerExist, 'src' => '/pic/article.banner/' . @$list['xarticleid'] . 'w200h150c1/' . str_random() . '.png?nocache=1', 'action' => 'deleteImg',  'id' => @$list['xarticleid'], 'name'=>'article/banner', 'type' => 'banner'])
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
            <tr>
                <td colspan="2">
                    <table class="table ">
                        <tr>
                            <th>@lang('language.picture')</th>
                            <th>@t('advertise')</th>
                        </tr>
                        <tr>
                            <td>
                                @include('admin.partial.fileInput', ['exist' => @$advImgExist, 'src' => '/pic/article.advertise/' . @$list['xarticleid'] . 'w200h150c1/' . str_random() . '.png?nocache=1', 'action' => 'deleteAdvertiseImg',  'id' => @$list['xarticleid'], 'name'=>'article/advertise', 'type' => 'image'])
                            </td>
                            <td>
                            <div class="form-group">
                                    <div class="input-icon">
                                        <i class="fa fa-file"></i>
                                        {!! Form::text('frm[adv_url]', @$list['adv_url'], array('class' =>
                                        'form-control')) !!}
                                    </div>
                                </div>
                            </td>
                        </tr>
                    </table>
                </td>
            </tr>
        </table>

    </div>
</div>
<script>
    App.tinymceInit('.tinymce_editor');
</script>
@stop
