<?php namespace Modules\Blog\Models;

use DB;
use stdClass;
use App\Models\Model;
use Modules\Account\Models\UserInfo;
use App; 
use Modules\Comment\Models\Comment;
use Modules\Home\Models\Tag;

class RatingInfo extends Model
{
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'rating_info';

    /**
     * The primary key for the model.
     *
     * @var string
     */
    protected $primaryKey = 'user_id';

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;
    public $lang = false;
    protected $guarded = ['id'];

    protected $casts = [
        'user_id' => 'int',
        'article_id' => 'int',
    ];

    public function user()
    {
        return $this->belongsTo(UserInfo::class,'user_id');
    }

    public function article()
    {
        return $this->belongsTo(Article::class,'article_id');
    }

    /**
     * get Result
     * @param $query
     * @return mixed
     */
    public static function getResult()
    {
        $instance = new static();

        $res = DB::table($instance->table)
            ->select(['*', "{$instance->primaryKey} AS xid"]);

        return $res;
    }
    
    public static function updateById($data,$keys=null)
    {
        $instance = new static();
        if($keys)
            return $instance->updateOrCreate(['user_id'=>$keys['user_id'], 'article_id'=>$keys['article_id']],$data);
        else
            return $instance->updateOrCreate(null,$data);
    }

    /**
     * delete
     * @param $id
     * @return mixed
     */
    public static function remove($id)
    {
        $instance = new static();

        if ($id){
            $res = $instance->destroy($id);
            parent::deleteFile($id);
            die('[[OK]]'); 
        }
        else
            die('[[Error]]');
        return $res;
    }
}