<?php namespace Modules\Blog\Models;

use DB;
use stdClass;
use App\Models\Model;

class ArticleSubGroup extends Model
{
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'xxarticlesubgroup';

    /**
     * The primary key for the model.
     *
     * @var string
     */
    protected $primaryKey = 'xarticlesubgroupid';

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;

    /**
     * get Result
     * @param $query
     * @return mixed
     */
    public static function getResult()
    {
        $instance = new static();

        $res = DB::table($instance->table)
            ->select(['*', "{$instance->primaryKey} AS xid"]);

        return $res;
    }

    /**
     * get First
     * @param $id
     * @return mixed
     */
    public static function first($id)
    {
        $instance = new static();
        
        $res = self::getResult()
            ->where($instance->primaryKey, $id)
            ->first();
        return $res;
    }

    /**
     * update or insert
     * @param $data
     * @param int $id
     * @return int
     */
    public static function store($data, $id = 0)
    {
        $instance = new static();
        if (!$id)
            $id = $instance->newQuery()->insertGetId($data);
        else
            $instance->newQuery()->where($instance->primaryKey, intval($id))->update($data);
        
        return $id;
    }

    /**
     * delete
     * @param $id
     * @return mixed
     */
    public static function remove($id)
    {
        $instance = new static();

        $cond = (int) $id ? "{$instance->primaryKey} = '$id'" : $id;

        $res = $instance->newQuery()->whereRaw($cond)->delete();
        return $res;
    }
}