<?php namespace Modules\Blog\Models;

use DB;
use stdClass;
use App\Models\Model;
use App;

class ArticleGroup extends Model
{
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'xxarticlegroup';

    /**
     * The primary key for the model.
     *
     * @var string
     */
    protected $primaryKey = 'xarticlegroupid';

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;
    protected $guarded = ['xarticlegroupid'];

    protected $casts = [
        'xrank' => 'int',
    ];

    public function parent() {
        return $this->belongsTo(ArticleGroup::class, 'parent_id');
    }

    /**
     * Get the category that owns the sub category.
     */
    public function childs() {
        return $this->hasMany(ArticleGroup::class, 'parent_id');
    }

    public function article()
    {
        return $this->hasMany('Modules\Blog\Models\Article','xarticlegroupid');
    }

    /**
     * get Result
     * @param $query
     * @return mixed
     */
    public static function getResult()
    {
        $instance = new static();
        $res = DB::table($instance->table)
            ->select(array('*', $instance->primaryKey . ' AS xid'))
            ->where('xlang' , App::getLocale());

        return $res;
    }
    
    public static function updateById($data,$id=0)
    {
        $instance = new static();
        return $instance->updateOrCreate([$instance->primaryKey => $id],$data);
    }

    /**
     * delete
     * @param $id
     * @return mixed
     */
    public static function remove($id)
    {
        $instance = new static();

        if ($id){
            $res = $instance->destroy($id);
            parent::deleteFile($id);
            die('[[OK]]'); 
        }
        else
            die('[[Error]]');
        return $res;
    }
}