<?php namespace Modules\Blog\Models;

use DB;
use stdClass;
use App\Models\Model;
use Modules\Account\Models\UserInfo;
use App; 
use Modules\Comment\Models\Comment;
use Modules\Home\Models\Tag;

class Article extends Model
{
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'xxarticle';

    /**
     * The primary key for the model.
     *
     * @var string
     */
    protected $primaryKey = 'xarticleid';

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = true;
    protected $guarded = ['xarticleid'];

    protected $casts = [
        'xrank' => 'int',
        'xuserid' => 'int',
        'xarticle_duration' => 'int',
    ];

    public function user()
    {
        return $this->belongsTo(UserInfo::class,'xuserid');
    }

    public function group()
    {
        return $this->belongsTo('Modules\Blog\Models\ArticleGroup','xarticlegroupid');
    }

    public function rating()
    {
        return $this->hasMany(RatingInfo::class,'article_id');
    }

    /**
     * Get all of the book's comments.
     */
    public function comments() {
        return $this->morphMany(Comment::class, 'xcommentable');
    }

    public function tags() {
        return $this->morphToMany(Tag::class, 'taggable', 'xxtaggables', 'taggable_id', 'tag_id');
    }

    /**
     * get Result
     * @param $query
     * @return mixed
     */
    public static function getResult()
    {
        $instance = new static();

        $res = DB::table($instance->table)
            ->select(['*', "{$instance->primaryKey} AS xid"])
            ->where('xlang' , App::getLocale());

        return $res;
    }
    
    public static function updateById($data,$id=0)
    {
        $instance = new static();
        return $instance->updateOrCreate([$instance->primaryKey => $id],$data);
    }

    /**
     * delete
     * @param $id
     * @return mixed
     */
    public static function remove($id)
    {
        $instance = new static();

        if ($id){
            $res = $instance->destroy($id);
            parent::deleteFile($id);
            die('[[OK]]'); 
        }
        else
            die('[[Error]]');
        return $res;
    }
}