<?php 
namespace Modules\Blog\Http\Controllers\Admin;

use App\Http\Controllers\BackendController;
use Modules\Blog\Models\Article;
use Modules\Blog\Models\ArticleGroup;
use Input;
use DB;
use App;

class ArticleGroupController extends BackendController {
    public $title = "articlegroup";

    //## list
    public function index()
    {

        $this->field[] =  array('php' => 'echo $item["xarticlegroup_title"];', 'name' => trans('language.title'), 'css' => 'width: 10%', 'sortable' => 'xarticlegroup_title');
        $this->field[] =  array('php' => 'echo $item["xrank"];', 'name' => trans('language.display rank'), 'css' => 'width: 5%', 'sortable' => 'xrank');
    
        $this->list = ArticleGroup::getResult();
        $this->paginate();
    }

    //## new
    public function create($id = 0)
    {
        $this->layout->title = 'articlegroup';
        $this->layout->content->artList = [1];
    }

    public function edit($id)
    {
        $article = ArticleGroup::find($id);
        $this->layout->content->list = $article;
        
        $this->layout->title = 'articlegroup';
    }
    //## edit

    //## store
    public function store($id)
    {
        $frm = Input::get('frm');
        $book = ArticleGroup::updateById($frm,$id);
        $this->saveFile($id);
        die('[[OK]]');
    }

    //## delete
    public function delete($id)
    {
        if ($id) {
            $res = ArticleGroup::remove($id);
            die('[[OK]]');
        } else {
            die('[[Error]]');
        }
    }

    
}