<?php 
namespace Modules\Blog\Http\Controllers\Admin;

use App\Http\Controllers\BackendController;
use Modules\Blog\Models\ArticleGroup;
use Modules\Blog\Models\Article;
use Modules\Home\Models\Tag;
use Modules\Account\Models\User;
use Input;
use File;
use App;
use Auth;
use Modules\Blog\Http\Controllers\Index\BlogController;

class ArticleController extends BackendController {
    public $title = "article";
    
    function __construct(){
        $this->model = Article::query();
        parent::__construct();
    }

    protected $scaffold = [
        'checkbox' => true,
        'footerSum' => false
    ];

    protected  $fields = [

        'xarticle_title' => [
            'name' => 'xarticle_title',
            'listView' => true,
            'searchView' => true,
            'text' => 'عنوان',
            'orderable' => true,
            'type' => 'text'
        ],
        'url' => [
            'name' => 'url',
            'listView' => false,
            'searchView' => true,
            'text' => 'لینک',
            'type' => 'text'
        ],
        'xarticle_duration' => [
            'name' => 'xarticle_duration',
            'listView' => false,
            'searchView' => false,
            'text' => 'مدت زمان مطالعه',
            'type' => 'number'
        ],
        'xarticle_abstract' => [
            'name' => 'xarticle_abstract',
            'listView' => false,
            'searchView' => false,
            'text' => 'خلاصه',
            'type' => 'textarea'
        ],
        'xarticle_desc' => [
            'name' => 'xarticle_desc',
            'listView' => false,
            'searchView' => false,
            'text' => 'متن مقاله',
            'type' => 'tinymce'
        ],
        'tags' => [
            'name' => 'tags',
            'listView' => false,
            'searchView' => false,
            'text' => 'کلیدواژه',
            'type' => 'tag'
        ],
        'updated_at' => [
            'name' => 'updated_at',
            'text' => 'تاریخ',
            'orderable' => true,
            'listView' => true,
            'searchView' => true,
            'width' => '120px',
            'type' => 'pdateTime',
            'render' => 'persianDate'
        ],
        'xrank' => [
            'name' => 'xrank',
            'text' => 'اولویت',
            'orderable' => true,
            'listView' => true,
            'width' => '30px',
            'type' => 'number'
        ],
        'action' => [
            'name' => 'action',
            'text' => 'عملیات',
            'orderable' => true,
            'listView' => true,
            'className' => 'dt-left',
            'render' => 'defaultAction',
            'width' => '120px',
        ],


    ];

    //## list
	public function index()
	{
        $this->field[] =  array('php' => 'echo \'<div style="text-align: center;"><img src="/pic/article.image/\' . $item["xarticleid"] . "w120h100c1/". str_random() . ".png?nocache=1" . \'" alt="" /></div>\';',
           'name' => trans('language.picture'), 'css' => 'width: 3%');

        $this->field[] =  array('php' => 'echo $item["xarticle_title"];', 'name' => trans('language.title'), 'css' => 'width: 10%', 'sortable' => 'xarticle_code');
        // $this->field[] =  array('php' => 'echo Str::words($item["xarticle_desc"],10);', 'name' => @t('description'), 'css' => 'width: 10%', 'sortable' => 'xarticle_desc');
        $this->field[] =  array('php' => 'echo FarsiLib::g2jDate($item["updated_at"],true);', 'name' => 'تاریخ به روزرسانی', 'css' => 'width: 10%', 'sortable' => 'updated_at');
        $this->field[] =  array('php' => 'echo FarsiLib::g2jDate($item["created_at"],true);', 'name' => 'تاریخ ایجاد', 'css' => 'width: 10%', 'sortable' => 'created_at');
        $this->field[] =  array('php' => 'echo $item["xrank"];', 'name' => trans('language.display rank'), 'css' => 'width: 5%', 'sortable' => 'xrank');
            

        $this->list = Article::getResult()->orderBy('updated_at','desc');
        $this->paginate();
        $this->layout->content->listBtn['showView'] = true;
	}

    //## new
    public function create($id = 0)
    {
        $this->layout->content->articleList = [1];
        $this->layout->title = 'article';
    }

    public function view($id)
    {
        $blog = new BlogController();
        return $blog->callAction('detailArticle',[$id]);
    }

    //## edit
    public function edit($id)
    {
       // $this->layout->content->values = Article::find($id);
       $this->layout->content->list =  Article::find($id);;
        $this->layout->content->fields = $this->fields;
        $this->layout->content->imgExist = File::exists(config('upload.' . config('app.controller')) . "/image" . "/$id");
        $this->layout->content->advImgExist = File::exists(config('upload.' . config('app.controller')) . "/advertise" . "/$id");
        $this->layout->content->bannerExist = File::exists(config('upload.' . config('app.controller')) . "/banner" . "/$id");
    }

    //## store
    public function store($id)
    {
        $frm = Input::get('frm');
        $tags = Input::get('tags');
        $newTags = Input::get('tagInput');

        $frm['xuserid'] = $frm['xuserid'] ?? Auth::id();
        $frm['url'] = strlen(@$frm['url']) ? $frm['url'] : $frm['xarticle_title'];
        
        $article = Article::updateById($frm,$id);
        $this->saveFile($article->xarticleid);

        $article->tags()->detach();
        $newTags = explode(',,', $newTags);
        if ($tags) {
            foreach ($tags as $key => $value) {
                if (!in_array($value, $newTags)) {
                    $article->tags()->attach($value);
                } else {
                    $article->tags()->create(['xname' => $value]);
                }

            }
        }

        die('[[OK]]');
    }

     //## delete
    public function delete($id)
    {
        if ($id) {
            $res = Article::remove($id);
            File::delete(config('upload.' . config('app.controller'))  . "/image/$id");
            File::delete(config('upload.' . config('app.controller')) . "/banner/$id");
            die('[[OK]]');
        } else {
            die('[[Error]]');
        }
    }

    //## delete logo
    public function deleteImg($id)
    {
        $type = Input::get('type');
        File::delete(config('upload.' . config('app.controller'))  ."/".$type . "/$id");
        die('[[OK]]');
    }

    //## set combo
    public function setCombo()
    {
        $this->layout->groupList = $this->layout->content->groupList = ArticleGroup::getWithLocale()->pluck('xarticlegroup_title','xarticlegroupid');
        $this->layout->tagList = $this->layout->content->tagList = Tag::pluck('xname', 'xtagid');   
        $this->layout->userList = $this->layout->content->userList = User::select(['xusername', 'xuserid'])->pluck('xusername', 'xuserid');
    }
}