<?php namespace Modules\Blog\Entities;

use DB;
use App; 

class SeoSchema 
{
    public static function schemaArticle($article,$siteTitle){
        $string = trim(preg_replace('/\s+/', ' ', $article->xarticle_desc));
        $words = explode(" ", $string);

        $schema = [
            "@context"=> "http://schema.org",
            "@type"=> "BlogPosting",
            "headline"=> $article->xarticle_title,
            "image"=> [
                "@type"=> "ImageObject",
                "url"=> config('app.url')."/pic/article.image/{$article->xarticleid}w855h300c1/{$article->xarticleid}.jpg",
                "height"=> 855,
                "width"=> 300
            ],
            "author"=> $article->user->xname.' '.$article->user->xfamily,
            "editor"=> $article->user->xname.' '.$article->user->xfamily,
            "genre"=> "لوازم خانگی",
            "wordcount"=> count($words),
            "publisher"=> [
                "@type"=> "Organization",
                "name"=> $siteTitle,
                "logo"=> [
                    "@type"=> "ImageObject",
                    "url"=> config('app.url')."/goldiran/logo.png",
                    "width"=> "658",
                    "height"=> "221"
                ]
            ],
            "url"=> config('app.url')."/blog/".str_replace(' ','-',$article->xarticle_title),
            "datePublished"=> $article->created_at->format('Y-m-d'),
            "dateCreated"=> $article->created_at->format('Y-m-d'),
            "dateModified"=> $article->updated_at->format('Y-m-d'),
            "description"=> $article->seo_description,
        ];
        return $schema;
        return array_merge($schema,self::schemaReview($article));
    }

    public static function schemaVideo($article){
        $string = trim(preg_replace('/\s+/', ' ', $article->xarticle_desc));
        $words = explode(" ", $string);

        preg_match('/<video.*>[^<]*<source[^src]* src="([^"]*)/m',$article->xarticle_desc,$matches);

        $schema = [
            "@context"=> "http://schema.org",
            "@type"=> ["VideoObject", "BlogPosting"],
            "headline"=> $article->xarticle_title,
            "image"=> [
                "@type"=> "ImageObject",
                "url"=> config('app.url')."/pic/article.image/{$article->xarticleid}w855h300c1/{$article->xarticleid}.jpg",
                "height"=> 855,
                "width"=> 300
            ],
            "author"=> $article->user->xname.' '.$article->user->xfamily,
            "editor"=> $article->user->xname.' '.$article->user->xfamily,
            "genre"=> "لوازم خانگی",
            "wordcount"=> count($words),
            "publisher"=> [
                "@type"=> "Organization",
                "name"=> $this->$config['seo']['title'],
                "logo"=> [
                    "@type"=> "ImageObject",
                    "url"=> config('app.url')."/goldiran/logo.png",
                    "width"=> "658",
                    "height"=> "221"
                ]
            ],
            "name" => $article->xarticle_title,
            "thumbnailUrl"=> config('app.url')."/pic/article.image/{$article->xarticleid}w855h300c1/{$article->xarticleid}.jpg",
            "uploadDate"=> date('Y-m-d',$article->created_at),
            "contentUrl"=> config('app.url').$matches[1],
            "duration"=> "T0H3M42S", 
            "url"=> config('app.url')."/blog/".str_replace(' ','-',$article->xarticle_title),
            "datePublished"=>date('Y-m-d',$article->created_at),
            "dateCreated"=> date('Y-m-d',$article->created_at),
            "dateModified"=> date('Y-m-d',$article->updated_at),
            "description"=> $article->seo_description,
            
        ];

        return $schema;
    }

    public static function schemaProductForArticle($article){
        $schema = [
            "@context" => "http://schema.org",
            "@type" => "Product",
            "description" => $article->seo_description,
            "name" => $article->xarticle_title,
            "image" => config('app.url')."/pic/article.image/{$article->xarticleid}w855h300c1/{$article->xarticleid}.jpg",
        ];

        return array_merge($schema,self::schemaReviewArticle($article));
    }

    public static function schemaBreadcrumb($article){
        $schema = [
            "@context"=> "http://schema.org",
            "@type"=> "BreadcrumbList",
            "itemListElement"=> [
                [
                "@type"=> "ListItem",
                "position"=> 1,
                "item"=> [
                    "@id"=> config('app.url'),
                    "name"=> "خانه"
                    ]
                ], 
                [
                "@type"=> "ListItem",
                "position"=> 2,
                "item"=> [
                    "@id"=> config('app.url') . '/Blog/category/' . $article->group->xarticlegroupid,
                    "name"=> $article->group->xarticlegroup_title
                    ]
                ] 
            ]
        ];
        return $schema;
    }

    public static function schemaReviewArticle($article){
        $schemaReview = [];
        if($article->comments->count())
            foreach($article->comments()->take(10)->get() as $comment){
                $schemaReview[] = [
                    "@type"=> "Review",
                    "author"=> $comment->user->xname.' '.$comment->user->xfamily,
                    "datePublished"=> date('Y-m-d',$comment->xcomment_date),
                    "description"=> $comment->xcomment_content,
                    "reviewRating"=> [
                        "@type"=> "Rating",
                        "bestRating"=> "5",
                        "ratingValue"=> "5",
                        "worstRating"=> "1"
                    ]
                ];
            }
        else
            $schemaReview[] = [
                "@type"=> "Review",
                "author"=> "کارشناس فنی",
                "datePublished"=> "2020-01-01",
                "description"=> "مقاله بسیار خوبی در زمینه تعمیر لوازم جانبی ",
                "reviewRating"=> [
                    "@type"=> "Rating",
                    "bestRating"=> "5",
                    "ratingValue"=> "5",
                    "worstRating"=> "1"
                ]
            ];
        return [
            "review" => $schemaReview,
            "aggregateRating" => [
                "@type"=> "AggregateRating",
                "ratingValue"=> "4.7",
                "reviewCount"=> "10"
            ]
        ];
    }

    public static function schemaWebSite(){
        $schema = [
            "@context" => "http://schema.org",
            "@type" => "WebSite",
            "url" => config('app.url'),
            "potentialAction" => [
                "@type" => "SearchAction",
                "target" => config('app.url')."/?s={search_term_string}",
                "query-input" => [
                    "@type" => "PropertyValueSpecification",
                    "valueRequired" => true,
                    "valueMaxlength" => 100,
                    "valueName" => "search_term_string"
                ]
            ]
        ];
        return $schema;
    }
}