<?php namespace Modules\Author\Http\Controllers\Index;

use App\Http\Controllers\IndexController;
use Modules\Book\Models\Book;
use Modules\Author\Models\Author;
use Request;
use Session;
use Input;
use App;
use DB;
use Auth;
use Redirect;
use File;

class AuthorController extends IndexController {

	/**
	 * Show the application dashboard to the user.
	 *
	 * @return Response
	 */
	public function  index()
	{ 
        $authors =Author::orderBy('xrank','desc')->orderBy('xauthor_name','asc')->get();

        $breadcrumb[]=['title'=>t('author'), 'href'=> ''];
		$this->layout->breadcrumb = $breadcrumb;

      	$this->layout->title2 = t('author');
        $this->layout->content = view('author::index.list', [
            'authors'=>$authors,
        ]);
	}
	
	public function detail($id, $title=null)
	{

		$author = Author::find($id);
        
		$breadcrumb[]=['title'=>t('author'), 'href'=> 'Author'];
		$breadcrumb[]=['title'=> $author->xauthor_name, 'href'=> ''];

		$imgExist = File::exists(config('upload.' . config('app.controller')) . "/$id");

		$this->layout->breadcrumb = $breadcrumb;		
		$this->layout->title2 = t('author');
        $this->layout->content = view('author::index.detail',[
        	'author'=>$author,
        	'imgExist' => $imgExist
        ]);
	}

}
