@section('content')
    <div class="col-md-12">
        <div class="table-responsive">
            <table class="table table-bordered table-striped">   
                <tr>
                    <td width="20%">@t('location'): </td>
                    <td>
                        <div class="form-group">
                            {!! Form::select('frm[xlocation]', @$locationList, @$list['xlocation'], ['class' => 'form-control location', 'style' => 'width: 100%' ,'data-advancedselect' => 'select2'])  !!}    
                        </div>
                        </div>
                    </td>
                </tr> 
                <tr>
                    <td>@t('item'): </td>
                    <td>
                        <div class="form-group">
                            {!! Form::select('frm[xlocationid]', [], @$list['xlocationid'], ['class' => 'form-control items', 'style' => 'width: 100%', 'data-advancedselect' => 'select2'])  !!}    
                        </div>
                        </div>
                    </td>
                </tr>            

                
                <tr>
                    <td>@t('title'): </td>
                    <td>
                        <div class="form-group">
                            <div class="input-icon">
                            <i class="fa fa-th"></i>
                            {!! Form::text('frm[xtitle]', @$list['xtitle'], array('class' => 'form-control', ))  !!}
                            </div>
                        </div>
                    </td>
                </tr>

                 <tr>
                    <td>@t('price'): </td>
                    <td>
                        <div class="form-group">
                            <div class="input-icon">
                            <i class="fa fa-th"></i>
                            {!! Form::text('frm[xprice]', @$list['xprice'], array('class' => 'form-control', ))  !!}
                            </div>
                        </div>
                    </td>
                </tr>
                
                <tr>
                    <td>@lang('language.display rank'): </td>
                    <td>
                        <div class="form-group">
                            <div class="input-icon">
                            <i class="fa fa-th"></i>
                            {!! Form::text('frm[xrank]', @$list['xrank'], array('class' => 'form-control', ))  !!}
                            </div>
                        </div>
                    </td>
                </tr>

                <tr>
                    <td>@t('status'):</td>
                    <td>
                        <div class="form-group">
                            <div class="input-icon">
                                {!! Form::hidden('frm[xstatus]', 0)!!}
                               <label class="el-switch el-switch-green">
                                {!! Form::checkbox('frm[xstatus]', 1, @$list['xstatus'],array('class'=>'no-checker'))  !!} 
                                    <span class="el-switch-style"></span>
                                </label>
                            </div>
                        </div>
                    </td>
                </tr>
            </table>
            
        </div>
    </div>
    <script type="text/javascript">
        var locationItemList = {!! json_encode($locationItemList) !!};
        $(document).ready(function(){
            
            App.setSubGroup(locationItemList, 0, $('select.location'), $('select.items'),{{@$list['xlocationid']}});
            
            $(document).on('change','select.location',function(){
                App.setSubGroup(locationItemList, 0, $('select.location'), $('select.items'));
            });
        });
    </script>
@stop