<?php namespace Modules\Advertise\Models;

use App\Models\Model;
use DB;

class Advertise extends Model {
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'xxadvertise';

    /**
     * The primary key for the model.
     *
     * @var string
     */
    protected $primaryKey = 'xadvertiseid';

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;

    public $lang = false;

    protected $guarded = ['xadvertiseid'];

    protected $casts = [
        'xrank' => 'int',
        'xplaceid' => 'int',
        'xuserid' => 'int',
    ];

    public function ips() {
        return $this->hasMany(AdvertiseIp::class, 'xadvertiseid');
    }

    /**
     * get Result
     * @param $query
     * @return mixed
     */
    public static function getResult() {
        $instance = new static();

        $res = DB::table($instance->table . ' AS a')
            ->leftJoin('xxsecurity_userinfo as ui', 'ui.xuserid', '=', 'a.xuserid')
            ->select(['*', "a.{$instance->primaryKey} AS xid"]);

        return $res;
    }

    public static function updateById($data, $id = 0) {
        $instance = new static();
        return $instance->updateOrCreate([$instance->primaryKey => $id], $data);
    }

    /**
     * delete
     * @param $id
     * @return mixed
     */
    public static function remove($id) {
        $instance = new static();

        if ($id) {
            $res = $instance->destroy($id);
            parent::deleteFile($id);
            die('[[OK]]');
        } else {
            die('[[Error]]');
        }

        return $res;
    }
}