<?php namespace Modules\Advertise\Http\Controllers\Index;

use App;
use App\Http\Controllers\IndexController;
use Modules\Advertise\Models\Advertise;
use Request;

class AdvertiseController extends IndexController {

    /*
    |--------------------------------------------------------------------------
    | Home Controller
    |--------------------------------------------------------------------------
    |
    | This controller renders your application's "dashboard" for users that
    | are authenticated. Of course, you are free to change or remove the
    | controller as you wish. It is just here to get your app started!
    |
     */

    /**
     * Show the application dashboard to the user.
     *
     * @return Response
     */
    public function index() {
        $sort = 'xproduct_rank';
        $orderby = 'desc';
        $cat = SubCategory::get();

        $breadcrumb[] = ['title' => t('book'), 'href' => ''];
        $this->layout->breadcrumb = $breadcrumb;

        $this->layout->title = t('book');
        $this->layout->content = view('book::index.widget.categoryList', [
            'list' => $cat,
            'title' => 'دسته بندی کتب',
        ]);
    }

    public function link($id) {
        $adv = Advertise::find($id);
        if (!$adv) {
            return redirect('/');
        }

        $ip = Request::ip();
        $adv->xclicked++;
        $adv->save();

        if (!$adv->ips()->where('xip', $ip)->count()) {
            $adv->ips()->create([
                'xip' => $ip,
                'xtype' => 1,
            ]);
        }

        return redirect("/{$adv->xurl}");

    }
}
