<?php namespace Modules\Advertise\Http\Controllers\Admin;

use App\Http\Controllers\BackendController;
use Modules\Advertise\Models\AdvertisePlace;
use Modules\Author\Models\Author;
use Modules\Publisher\Models\Publisher;
use Modules\Blog\Models\ArticleGroup;
use Config;
use Input;
use File;
use App;
use DB;

class AdvertisePlaceController extends BackendController {
    public $title = "advertise place";

    //## list
    //Str::words($item["xvideo_desc"],25);
    //FarsiLib::faNormalizeNumber($item["xevent_price"])
    //FarsiLib::g2jDate($item["xstart"],true);
	public function index()
	{
        $this->field[] =  array('php' => 'echo $item["xtitle"];', 'name' =>  @t('title'), 'css' => 'width: 10%', 'sortable' => 'xtitle');
        $this->field[] =  array('php' => 'echo t($item["xlocation"]);', 'name' =>  @t('location'), 'css' => 'width: 10%', 'sortable' => 'xlocation');
        $this->field[] =  array('php' => 'echo FarsiLib::convertDigit($item["xprice"]);', 'name' =>  @t('price'), 'css' => 'width: 10%', 'sortable' => 'xprice');
        $this->field[] =  array('php' => 'echo $item["xrank"];', 'name' => trans('language.display rank'), 'css' => 'width: 10%', 'sortable' => 'xrank');

        $this->list = AdvertisePlace::getResult();
        $this->paginate();        
        
	}

    //## new
    public function create($id = 0)
    {
        $this->layout->title = $this->title;
    }

    //## edit
    public function edit($id)
    {
        $this->layout->content->list = AdvertisePlace::find($id);
        $this->layout->title = $this->title;
    }

    //## store
    public function store($id)
    {
        $frm = Input::get('frm');
        $book = AdvertisePlace::updateById($frm,$id);
        die('[[OK]]');
        
    }

    //## delete
    public function delete($id)
    {
        AdvertisePlace::remove($id);
        
    }

    //## set combo
    public function setCombo()
    {
        $locationList = AdvertisePlace::fetchEnum('xlocation');
        $this->layout->locationList = $this->layout->content->locationList = $locationList;

        $locationItemList = [];
        $locationItemList['Home']['home'] = 1;
        $authors = Author::all();
        foreach ($authors as $key => $value) {
            $locationItemList['Author'][@$value['xauthor_name']] = @$value['xauthorid'];    
        }
        
        $publisher = Publisher::all();
        foreach ($publisher as $key => $value) {
            $locationItemList['Publisher'][@$value['xpublisher_name']] = @$value['xpublisherid'];    
        }

        $articleGroup = ArticleGroup::getWithLocale();
        foreach ($articleGroup as $key => $value) {
            $locationItemList['Blog'][@$value['xarticlegroup_title']] = @$value['xarticlegroupid'];    
        }

        $this->layout->locationItemList = $this->layout->content->locationItemList = $locationItemList;
    }

}