<?php namespace Modules\Advertise\Http\Controllers\Admin;

use App\Http\Controllers\BackendController;
use Config;
use DB;
use File;
use Input;
use Modules\Account\Models\UserInfo;
use Modules\Advertise\Exports\IpExport;
use Modules\Advertise\Models\Advertise;
use Modules\Advertise\Models\AdvertisePlace;

class AdvertiseController extends BackendController {
    public $title = "advertise";

    //## list
    //Str::words($item["xvideo_desc"],25);
    //FarsiLib::faNormalizeNumber($item["xevent_price"])
    //FarsiLib::g2jDate($item["xstart"],true);
    //FarsiLib::g2jDate(date('m/d/Y H:i:s',@$list->xcomment_date),true)
    //FarsiLib::j2gDate() convert input from form
    public function index() {
        $this->field[] = array('php' => 'echo \'<div style="text-align: center;"><img src="/pic/advertise/\' . $item["xadvertiseid"] . "w120h100c1/". str_random() . ".png?nocache=1" . \'" alt="" /></div>\';',
            'name' => trans('language.picture'), 'css' => 'width: 3%');
        $this->field[] = array('php' => 'echo $item["xname"]." ".$item["xfamily"];', 'name' => @t('name'), 'css' => 'width: 10%', 'sortable' => 'xuserid');
        $this->field[] = array('php' => 'echo FarsiLib::g2jDate($item["xstart"],true);', 'name' => @t('start'), 'css' => 'width: 10%', 'sortable' => 'xstart');

        $this->field[] = array('php' => 'echo FarsiLib::g2jDate($item["xend"],true);', 'name' => @t('end'), 'css' => 'width: 10%', 'sortable' => 'xend');

        $this->field[] = array('php' => 'echo $item["xrank"];', 'name' => trans('language.display rank'), 'css' => 'width: 10%', 'sortable' => 'xrank');

        $this->list = Advertise::getResult();

        $this->paginate();
        $this->layout->toolbar['showTools'] = true;
        $this->layout->content->listBtn['showCheckbox'] = true;

    }

    //## new
    public function create($id = 0) {
        $this->layout->title = $this->title;
    }

    //## edit
    public function edit($id) {
        $this->layout->content->list = Advertise::find($id);
        $this->layout->content->imgExist = File::exists(config('upload.' . config('app.controller')) . "/$id");
        $this->layout->title = $this->title;
    }

    //## store
    public function store($id) {
        $frm = Input::get('frm');
        $adv = Advertise::updateById($frm, $id);
        $this->saveFile($adv->xadvertiseid);
        die('[[OK]]');

    }

    //## delete
    public function delete($id) {
        Advertise::remove($id);

    }

    //## delete Image
    public function deleteImage($id) {
        File::delete(config('upload.' . config('app.controller')) . "/$id");
        die('[[OK]]');
    }

    //## set combo
    public function setCombo() {
        $this->layout->userList = $this->layout->content->userList = UserInfo::select([DB::Raw("CONCAT(xname, ' ', xfamily) AS xfullname"), 'xuserid'])->pluck('xfullname', 'xuserid');

        $this->layout->placeList = $this->layout->content->placeList = AdvertisePlace::pluck('xtitle', 'xplaceid');
    }

    public function excelExport() {
        $checkall = Input::get('checkall');
        $listchk = Input::get('listchk');

        $this->list = Advertise::getResult()
            ->leftJoin('xxadvertise_ip', 'xxadvertise_ip.xadvertiseid', '=', 'a.xadvertiseid')
            ->select(['a.xadvertiseid', 'a.xurl', 'xclicked', 'xdate', 'xip']);
        if (!$checkall && $listchk) {
            $this->list->whereIn('a.xadvertiseid', array_keys($listchk));
        }
        $this->setQueryToList();

        if (!$this->list->orders) {
            $this->list->orders = [[
                "column" => "a.xadvertiseid",
                "direction" => "desc",
            ]];
        }

        return (new IpExport($this->list))->download('books.xlsx');
    }

}