@section('content')
    <div class="col-md-12">
        {{-- Username --}}
        <div class="form-group">
            <label class="control-label col-md-2">
               @lang('language.username'):
                <span class="required">*</span>
            </label>
            <div class="col-md-10" style="margin-bottom: 15px;">
                <div class="input-icon">
                    <i class="fa fa-user"></i>
                    <input type="text" name="frm[xxsecurity_user][xusername]" value="{{ @$list['xusername'] }}" class="form-control" autocomplete="off" required="required" title="{{ t('language.username is required') }}">
                </div>
            </div>
        </div>

        {{-- Password --}}
        <div class="form-group">
            <label class="control-label col-md-2">
               @lang('language.password'):
            </label>
            <div class="col-md-10" style="margin-bottom: 15px;">
                <div class="input-icon">
                    <i class="fa fa-lock"></i>
                    <input type="text" name="frm[xxsecurity_user][xpassword]" value="" class="form-control" autocomplete="off">
                </div>
            </div>
        </div>

        @if(@$authorList)
        <div class="form-group">
            <label class="control-label col-md-2">
               @t('author'):
            </label>
            <div class="col-md-10" style="margin-bottom: 15px;">
                {!! Form::select('frm[xxsecurity_user][xrelation_oneid]', @$authorList, @$list->xrelation_oneid, ['class' => 'form-control', 'data-advancedselect' => 'select2'])  !!}
            </div>
        </div>
        @endif

        @include('account::admin.edit.partial.userInfo')
        @include('account::admin.edit.partial.userImage')
    </div>
@stop