<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" @if(config('layout.self.rtl'))  direction="rtl" dir="rtl" @endif {{ Metronic::printAttrs('html') }} {{ Metronic::printClasses('html') }}>
    <head>
        <meta charset="utf-8"/>
        <meta name="csrf-token" content="{{ csrf_token() }}" />
        {{-- Title Section --}}
        <title>{{ config('app.name') }} | @yield('title', $page_title ?? '')</title>

        {{-- Meta Data --}}
        <meta name="description" content="@yield('page_description', $page_description ?? '')"/>
        <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no"/>
        <link href="/public/admin/css/pages/login/classic/login-4.css" rel="stylesheet" type="text/css" />
        {{-- Favicon --}}
        <link rel="shortcut icon" href="{{ asset('public/admin/media/logos/favicon.ico') }}" />

        {{-- Global Theme Styles (used by all pages) --}}
        @foreach(config('layout.resources.css') as $style)
            <link href="{{ config('layout.self.rtl') && false ? asset(Metronic::rtlCssPath($style)) : asset($style) }}" rel="stylesheet" type="text/css"/>
        @endforeach
        {{-- Layout Themes (used by all pages) --}}
        @foreach (Metronic::initThemes() as $theme)
            <link href="{{ config('layout.self.rtl') && false ? asset(Metronic::rtlCssPath($theme)) : asset($theme) }}" rel="stylesheet" type="text/css"/>
        @endforeach

        
    </head>

    <body id="kt_body" class="header-fixed header-mobile-fixed subheader-enabled subheader-fixed aside-enabled aside-fixed aside-minimize-hoverable page-loading">

        <div class="d-flex flex-column flex-root">
			<!--begin::Login-->
			<div class="login login-4 login-signin-on d-flex flex-row-fluid" id="kt_login">
				<div class="d-flex flex-center flex-row-fluid bgi-size-cover bgi-position-top bgi-no-repeat" style="background-image: url('/metronic/theme/html/demo1/dist/assets/media/bg/bg-3.jpg');">
					<div class="login-form text-center p-7 position-relative overflow-hidden">
						<!--begin::Login Header-->
						<div class="d-flex flex-center mb-15">
							<a href="#">
								<img src="/admin/media/logos/logo-letter-13.png" class="max-h-75px" alt="" />
							</a>
						</div>
						<!--end::Login Header-->
						@include('account::admin.auth.loginForm')
                        @include('account::admin.auth.forgetForm')
					</div>
				</div>
			</div>
			<!--end::Login-->
		</div>

        {{-- Global Config (global config for global JS scripts) --}}
        <script>
            var KTAppSettings = {!! json_encode(config('layout.js'), JSON_PRETTY_PRINT|JSON_UNESCAPED_SLASHES) !!};
        </script>
<script>
    var section = "{{ config('app.section') }}", 
    controller = "{{ config('app.controller') }}", 
    action = "{{ config('app.action') }}",  
    locale = "{{ config('app.localization') }}",
    lang = "{{ App::getLocale() }}", 
    environment = '{{ App::environment() }}', 
    random = "{{ config('app.random') }}";
    window.dir =  "{{ config('app.dir', 'ltr') }}";
</script>
        {{-- Global Theme JS Bundle (used by all pages)  --}}
        @foreach(config('layout.resources.js') as $script)
            <script src="{{ asset($script) }}" type="text/javascript"></script>
        @endforeach
        {{-- <script src="https://preview.keenthemes.com/metronic/theme/html/demo1/dist/assets/plugins/custom/datatables/datatables.bundle.js?v=7.1.2"></script> --}}
        {{-- Includable JS --}}
        @yield('scripts')
        {{-- <script src="{{ asset('/assets/scripts/custom/login.js') }}" type="text/javascript"></script> --}}
        
        <script>
            jQuery(document).ready(function () {
                
                // Login.init();
            });
        </script>
    </body>
</html>
