<?php namespace Modules\Account\Models;

use App\Models\Model;
use DB;
use stdClass;

class UserRole extends Model {
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'xxsecurity_userrole';

    /**
     * The primary key for the model.
     *
     * @var string
     */
    protected $primaryKey = 'xuser_roleid';

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;

    /**
     * get Result
     * @param $query
     * @return mixed
     */
    public static function getResult($query = null) {
        $instance = new static();
        $query = @$query ? $query : new stdClass();
        $query->where = @$query->where ? $query->where : 1;
        $query->order = (@$query->order and @$query->order != 'NULL') ? $query->order : 'NULL';
        $query->having = @$query->having ? $query->having : 1;

        $res = DB::table($instance->table . ' AS ur')
            ->leftJoin('xxsecurity_role AS ug', 'ug.xroleid', '=', 'ur.xroleid')
            ->whereRaw($query->where)
            ->orderByRaw($query->order)
            ->havingRaw($query->having)
            ->select(array('*', $instance->primaryKey . ' AS xid'));

        return $res;
    }

    /**
     * get First
     * @param $id
     * @return mixed
     */
    public static function first($id) {
        $instance = new static();
        $q = new stdClass();
        if (is_object($id)) {
            $q = $id;
        } else {
            $q->where = $instance->primaryKey . " = " . intval($id);
        }
        $res = self::getResult($q)->first();
        return $res;
    }

    /**
     * update or insert
     * @param $data
     * @param int $id
     * @return int
     */
    public static function store($data, $id = 0) {
        $instance = new static();
        if (!$id) {
            $id = $instance->newQuery()->insertGetId($data);
        } else {
            $instance->newQuery()->where($instance->primaryKey, intval($id))->update($data);
        }

        return $id;
    }

    /**
     * delete
     * @param $id
     * @return mixed
     */
    public static function remove($id) {
        $instance = new static();
        $q = new stdClass();
        $q->where = is_object($id) ? $id->where : ($instance->primaryKey . " = " . intval($id));

        $res = $instance->newQuery()->whereRaw($q->where)->delete();
        return $res;
    }
}