<?php namespace Modules\Account\Models;

use App\Models\Model;
use DB;
use Illuminate\Database\Eloquent\SoftDeletes;

class UserInfo extends Model {
    use SoftDeletes;
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'xxsecurity_userinfo';

    /**
     * The primary key for the model.
     *
     * @var string
     */
    protected $primaryKey = 'xuserid';

    /**
     * Fillable fields for a Profile.
     *
     * @var array
     */
    protected $fillable = [
        'xname',
        'xfamily',
        'twitter_username',
        'github_username',
        'xgender',
        'xbirthday',
        'xtel',
        'xfax',
        'xmobile',
        'xcurrentip',
        'xaddress',
        'xpostalcode',
    ];
    protected $casts = [
        'xuserid' => 'integer',
    ];

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;

    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $dates = ['deleted_at'];

    /**
     * A userinfo belongs to a user.
     *
     * @return mixed
     */
    public function user() {
        return $this->belongsTo(User::class, 'xuserid');
    }

    public function xfullname() {

        return $this->xname . ' ' . $this->xfamily;
    }

    /**
     * get Result
     * @param $query
     * @return mixed
     */
    public static function getResult() {
        $instance = new static();

        $res = DB::table($instance->table . ' AS ui')
            ->select(['*', "{$instance->primaryKey} as xid"]);

        return $res;
    }

    /**
     * get First
     * @param $id
     * @return mixed
     */
    public static function first($id) {
        $instance = new static();

        $res = self::getResult()
            ->where("ui.{$instance->primaryKey}", $id)
            ->first();

        return $res;
    }

    /**
     * update or insert
     * @param $data
     * @param int $id
     * @return int
     */
    public static function store($data, $id = 0) {
        $instance = new static();
        if (!$id) {
            $id = $instance->newQuery()->insertGetId($data);
        } else {
            $instance->newQuery()->where($instance->primaryKey, intval($id))->update($data);
        }

        return $id;
    }

    /**
     * delete
     * @param $id
     * @return mixed
     */
    public static function remove($id) {
        $instance = new static();

        $cond = !intval($id) ? $id : "{$instance->primaryKey} = '$id'";

        $res = $instance->newQuery()->whereRaw($cond)->delete();
        return $res;
    }
}