<?php namespace Modules\Account\Models;

use App\Models\Model;
use App\Traits\HasRoleAndPermission;
use Crypt;
use DB;
use Illuminate\Auth\Authenticatable;
use Illuminate\Auth\Passwords\CanResetPassword;
use Illuminate\Contracts\Auth\Authenticatable as AuthenticatableContract;
use Illuminate\Contracts\Auth\CanResetPassword as CanResetPasswordContract;
use Illuminate\Database\Eloquent\SoftDeletes;
use Modules\Book\Models\Book;
use Modules\Shop\Models\Product;
use Modules\Cart\Models\Address;
use Modules\Cart\Models\Invoice;

class User extends Model implements AuthenticatableContract, CanResetPasswordContract {

    use Authenticatable, CanResetPassword, HasRoleAndPermission, SoftDeletes;

    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'xxsecurity_user';

    /**
     * The primary key for the model.
     *
     * @var string
     */
    protected $primaryKey = 'xuserid';

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = true;

    /**
     * The attributes that should be mutated to dates.
     *
     * @var array
     */
    protected $dates = ['deleted_at'];

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = ['xusername', 'xpassword', 'xemail', 'xuser_status'];

    /**
     * The attributes excluded from the model's JSON form.
     *
     * @var array
     */
    protected $hidden = ['xpassword', 'xremember_token', 'xuser_status'];

    /**
     * Get the password for the user.
     *
     * @return string
     */
    public function getAuthPassword() {
        return $this->xpassword;
    }

    /**
     * Get the column name for the "remember me" token.
     *
     * @return string
     */
    public function getRememberTokenName() {
        return 'xremember_token';
    }

    public function userInfo() {
        return $this->hasOne(UserInfo::class, 'xuserid');
    }

    public function roles() {
        return $this->belongsToMany(Role::class, 'xxsecurity_userrole', 'xuserid', 'xroleid');
    }

    public function agent() {
        return $this->hasOne(Agent::class, 'xuserid');
    }

    public function articles() {
        return $this->hasMany('Modules\Blog\Models\Article');
    }

    public function comments() {
        return $this->hasMany('Modules\Comment\Models\Comment', 'xuserid');
    }

    public function address() {
        return $this->hasMany(Address::class, 'xuserid')->orderBy('xrank','desc');
    }

    public function invoices() {
        return $this->hasMany(Invoice::class, 'xuserid');
    }

    public function messages() {
        return $this->hasMany(Message::class, 'xuserid');
    }

    public function bookFavorites() {
        return $this->belongsToMany(Book::class, 'xxuser_favorite', 'xuserid', 'xbookid');
    }

    public function favorites() {
        return $this->belongsToMany(Product::class, 'shop_product_favorite', 'user_id', 'product_id');
    }

    public function itemPermission() {
        return $this->hasMany(ItemPermission::class,  'user_id');
    }

    public function isIncompleteInfo(){
        return !($this->userInfo->xname && $this->userInfo->xfamily && $this->userInfo->xintcode);
    }

    /**
     * get Result
     * @param $query
     * @return mixed
     */
    public static function getResult() {
        $instance = new static();

        $res = DB::table($instance->table . ' as u')
            ->leftJoin('xxsecurity_userinfo as ui', 'ui.xuserid', '=', 'u.xuserid')
            //->leftJoin('xxsecurity_userrole as ur', 'ur.xuserid', '=', 'u.xuserid')
            //->leftJoin('xxsecurity_role as r', 'r.xroleid', '=', 'ur.xroleid')
            ->whereNull('u.deleted_at')
            ->where('u.xuserid','!=',2)
            ->select([
                'u.xusername','u.xuser_status', 'ui.*',
               // DB::Raw("GROUP_CONCAT(r.xname SEPARATOR ', ') AS xgroupname"),
                DB::Raw("CONCAT(ui.xname, ' ', ui.xfamily) AS xfullname"),
                //DB::Raw('GROUP_CONCAT(r.xroleid ORDER BY r.xroleid) AS xroleid'),
                "u.{$instance->primaryKey} AS xid",
            ]);

        return $res;
    }

    /**
     * insert new user
     * @param $valueList array has to key user & userInfo
     * @param $groupList array array of user groups
     * @return mixed
     * @throws Exception
     */
    public static function store($valueList, $groupList, $id = 0) {
        $instance = new static();
        $id = (intval($id) ?: ((!is_array($groupList) and intval($groupList)) ? intval($groupList) : 0));

        if ($groupList) {
            //## get group id list
            $groups = [];
            if (is_array($groupList)) {
                foreach ($groupList as $key => $val) {
                    $groups[] = (intval($val) != 0 ? $val : Role::getResult()
                            ->where('ug.xname', trim($val))
                            ->pluck('xroleid'));
                }
            }
            
            DB::beginTransaction();

            //## check for empty password
            if (!empty($valueList[$instance->table]['xpassword'])) {
                $valueList[$instance->table]['xpayload'] = Crypt::encrypt($valueList[$instance->table]['xpassword']);
                $valueList[$instance->table]['xpassword'] = bcrypt($valueList[$instance->table]['xpassword']);
            } else {
                unset($valueList[$instance->table]['xpassword']);
            }

            //## check username exist
            if(!empty($valueList[$instance->table]['xusername'])){
                $username = strtolower($valueList[$instance->table]['xusername']);
                $userCond = "lower(u.xusername) = '$username'";
                $userCond .= ($id ? " AND  u.xuserid <> '$id'" : '');

                $userRow = User::getResult()
                    ->whereRaw($userCond)
                    ->first();

                if (intval(@$userRow['xuserid']) and !$id) {
                    die(json_encode(array('type' => 'error', 'message' => trans('language.username is already exist'))));
                }
            }

            $userId = $id;
            if ($id) {
                if(!empty($valueList[$instance->table]))
                    $instance->newQuery()->where($instance->primaryKey, intval($id))->update($valueList[$instance->table]);
            } else {
                $userId = $instance->newQuery()->insertGetId($valueList[$instance->table]);
            }

            if (!$userId) {
                DB::rollback();
                die(json_encode(array('type' => 'error', 'message' => trans('language.can not create user'))));
            }

            unset($valueList[$instance->table]);

            foreach ($valueList as $tbl => $fv) {
                $fv['xuserid'] = intval($userId);
                if ($id) {
                    DB::table($tbl)
                        ->where($instance->primaryKey, $id)
                        ->update($fv);
                } else {
                    DB::table($tbl)
                        ->insert($fv);
                }
            }

            //## delete user group permission
            $res = UserRole::where($instance->primaryKey, intval($userId))->delete();

            //## insert user group permission
            if (is_array($groupList)) {
                foreach ($groups as $group) {
                    //update groupuser
                    UserRole::store(['xuserid' => intval($userId), 'xroleid' => intval($group)]);
                }
            }

            DB::commit();
            return @$userId;
        } else {
            die(json_encode(array('type' => 'error', 'message' => trans('language.user group not selected'))));
        }
    }

    /**
     * remove
     * @param $cond
     * @param string $tablelist
     * @return mixed
     */
    public static function remove($id) {

        $instance = new static();

        if ($id) {
            $user = $instance->find($id);
            //$user->roles()->detach();
            $user->userInfo->delete();
            $user->delete();

            parent::deleteFile($id);
            parent::deleteFile($id, 'signature');
            die('[[OK]]');
        } else {
            die('[[Error]]');
        }

        return 0;
    }

}
