<?php namespace Modules\Account\Models;

use App\Models\Model;
use DB;

class Session extends Model {
    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'xxsecurity_session';

    /**
     * The primary key for the model.
     *
     * @var string
     */
    protected $primaryKey = 'xuserid';

    protected $casts = [
        'xuserid' => 'integer',
        'xdeviceid' => 'integer',
    ];

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;
    public $lang = false;
    protected $guarded = [];

    /**
     * Get owner commentable models.
     */
    public function user() {
        return $this->belongsTo(UserInfo::class, 'xuserid');
    }

    /**
     * get Result
     * @param $query
     * @return mixed
     */
    public static function getResult() {
        $instance = new static();

        $res = DB::table("{$instance->table} as c")
            ->leftJoin('xxsecurity_userinfo as ui', 'c.xuserid', '=', 'ui.xuserid')
            ->select(['c.*', "{$instance->primaryKey} AS xid", DB::Raw("CONCAT(ui.xname, ' ', ui.xfamily) AS xfullname")]);

        return $res;
    }

    public static function updateById($data, $id = 0) {
        $instance = new static();
        return $instance->updateOrCreate([$instance->primaryKey => $id], $data);
    }

    /**
     * delete
     * @param $id
     * @return mixed
     */
    public static function remove($id) {
        $instance = new static();

        if ($id) {
            $res = $instance->destroy($id);
            die('[[OK]]');
        } else {
            die('[[Error]]');
        }

        return $res;
    }
}