<?php

namespace Modules\Account\Models;

use App\Contracts\RoleHasRelations as RoleHasRelationsContract;
use App\Models\Model;
use DB;

class Role extends Model implements RoleHasRelationsContract {

    /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'xxsecurity_role';

    /**
     * The primary key for the model.
     *
     * @var string
     */
    protected $primaryKey = 'xroleid';

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = ['xname', 'xdetail'];

    /**
     * Role belongs to many permissions.
     *
     * @return BelongsToMany
     */
    public function permissions() {
        return $this->hasMany(Permission::class);
    }

    /**
     * Role belongs to many users.
     *
     * @return BelongsToMany
     */
    public function users() {
        return $this->belongsToMany(User::class, 'xxsecurity_userrole', 'xroleid', 'xuserid');
    }

    /**
     * Attach permission to a role.
     *
     * @param int|Permission $permission
     *
     * @return int|bool
     */
    public function attachPermission($permission) {
        return (!$this->permissions()->get()->contains($permission)) ? $this->permissions()->attach($permission) : true;
    }

    /**
     * Detach permission from a role.
     *
     * @param int|Permission $permission
     *
     * @return int
     */
    public function detachPermission($permission) {
        return $this->permissions()->detach($permission);
    }

    /**
     * Detach all permissions.
     *
     * @return int
     */
    public function detachAllPermissions() {
        return $this->permissions()->detach();
    }

    /**
     * Sync permissions for a role.
     *
     * @param array|Permission[]|Collection $permissions
     *
     * @return array
     */
    public function syncPermissions($permissions) {
        return $this->permissions()->sync($permissions);
    }

    /**
     * Create a new model instance.
     *
     * @param array $attributes
     */
    public function __construct(array $attributes = []) {
        parent::__construct($attributes);

        if ($connection = config('roles.connection')) {
            $this->connection = $connection;
        }
    }

    /**
     * get Result
     * @param $query
     * @return mixed
     */
    public static function getResult() {
        $instance = new static();

        $res = DB::table($instance->table . ' AS ug')
            ->where('xname','not like','programmer')
            ->where('xname','not like','admin')
            ->where('xname','not like','customer')
            ->select(['*', "{$instance->primaryKey} as xid"]);

        return $res;
    }

    public static function updateById($data, $id = 0) {
        $instance = new static();
        return $instance->updateOrCreate([$instance->primaryKey => $id], $data);
    }

    /**
     * remove
     * @param $cond
     * @param string $tablelist
     * @return mixed
     */
    public static function remove($id) {

        $instance = new static();

        if ($id) {
            $res = $instance->destroy($id);
            die('[[OK]]');
        } else {
            die('[[Error]]');
        }

        return $res;
    }
}
