<?php

namespace Modules\Account\Models;

use App\Contracts\PermissionHasRelations as PermissionHasRelationsContract;
use App\Traits\PermissionHasRelations;
use App\Traits\Slugable;
use App\Models\Model;

class Permission extends Model
{
        /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'xxsecurity_permission';

    /**
     * The primary key for the model.
     *
     * @var string
     */
    protected $primaryKey = 'xpermissionid';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = ['xcontroller', 'xaction', 'xtype', 'xroleid', 'xmodule'];

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;

    /**
     * Permission belongs to many roles.
     *
     * @return BelongsToMany
     */
    public function role()
    {
        return $this->belongsTo(Role::class);
    }

    /**
     * Create a new model instance.
     *
     * @param array $attributes
     */
    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);

        if ($connection = config('roles.connection')) {
            $this->connection = $connection;
        }
    }

    public static function updateById($data, $id = 0) {
        $instance = new static();
        return $instance->updateOrCreate([$instance->primaryKey => $id], $data);
    }
}
