<?php

namespace Modules\Account\Models;

use App\Contracts\PermissionHasRelations as PermissionHasRelationsContract;
use App\Traits\PermissionHasRelations;
use App\Traits\Slugable;
use App\Models\Model;

class ItemPermission extends Model
{
        /**
     * The database table used by the model.
     *
     * @var string
     */
    protected $table = 'xxsecurity_module_permission';

    /**
     * The primary key for the model.
     *
     * @var string
     */
    protected $primaryKey = 'id';

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = ['role_id', 'module_id', 'controllerable_id', 'type'];

    /**
     * Indicates if the model should be timestamped.
     *
     * @var bool
     */
    public $timestamps = false;

    public static $typeList = [1=>'edit', 2=>'delete', 3=>'view'];

    /**
     * Permission belongs to many roles.
     *
     * @return BelongsToMany
     */
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    /**
     * Create a new model instance.
     *
     * @param array $attributes
     */
    public function __construct(array $attributes = [])
    {
        parent::__construct($attributes);

        if ($connection = config('roles.connection')) {
            $this->connection = $connection;
        }
    }

    public static function updateById($data, $id = 0) {
        $instance = new static();
        return $instance->updateOrCreate([$instance->primaryKey => $id], $data);
    }
}
