<?php

namespace Modules\Account\Http\Controllers\Index;

use App\Http\Controllers\IndexController;
use Auth;
use Hash;
use Input;
use Modules\Account\Models\Role;
use Modules\Account\Models\User;
use Modules\Goldiran\Traits\GS;
use Redirect;
use Request;
use Session;
use SMS;
use Validator;

class UserController extends IndexController
{
    use GS;
    protected $layout = 'account::index.auth.layout';

    public function index()
    {
        if (Auth::user()) {
            return redirect('/');
        } else {
            return redirect('/User/login');
        }
    }
    /**
     * Show the Login to the user.
     *
     * @return Response
     */

    public function login()
    {
        if (Auth::id()) {
            return redirect('/');
        }

        $this->layout->content = view('account::index.auth.login');
    }

    public function register()
    {

        if (Auth::id()) {
            return redirect('/');
        }

        $this->layout->title = trans('register');
        $this->layout->content = view('account::index.auth.register');
    }

    public function forgot()
    {
        if (Auth::id()) {
            return back();
        }

        $this->layout->title = trans('forgot');
        $this->layout->content = view('account::index.auth.forgot');
    }

    public function welcome()
    {
        if (!Auth::id()) {
            return back();
        }

        $this->layout->title = trans('welcome');
        $this->layout->content = view('account::index.auth.welcome');
    }

    public function signupOtp()
    {
        if (Auth::id()) {
            return redirect('/');
        }

        $validator = Validator::make(Request::all(), [
            'mobile' => 'bail|required|unique:xxsecurity_user,xusername|max:255',
            'password' => 'required|min:6',
        ]);

        if ($validator->fails()) {
            return response()->json(['success' => false, 'errors' => $validator->errors()], 400);
            // return back()->withErrors($validator)->withInput();
        }

        Session::put('password', Input::get('password'));
        Session::save();

        self::sendOtp();
    }

    private function createUser($mobile, $password)
    {
        if (!$password) $password = \Str::random(7);
        //Set Proccess
        $role = Role::where('xname', '=', 'customer')->first();
        $user = User::create([
            'xusername' => $mobile,
            'xpassword' => Hash::make($password),
        ]);

        $userInfo = ['xmobile' => $mobile];
        if (config('app.theme') == 'goldiran' && $gsUserInfo = $this->gsGetCustomerInfoByMobile($mobile)) {
            if (is_string(@$gsUserInfo['CustomerFName'])) $userInfo['xname'] = $gsUserInfo['CustomerFName'];
            if (is_string(@$gsUserInfo['CustomerLName'])) $userInfo['xfamily'] = $gsUserInfo['CustomerLName'];
            if (@$gsUserInfo['ProvinceCode'] && @$gsUserInfo['CityId'] && @$gsUserInfo['parishId'] && @$gsUserInfo['Region']) {
                $user->address()->create([
                    'xprovinceid' => @$gsUserInfo['ProvinceCode'],
                    'xcityid' => @$gsUserInfo['CityId'],
                    'xregionid' => @$gsUserInfo['Region'],
                    'xparishid' => @$gsUserInfo['parishId'],
                    'xaddress_home_phone' => @$gsUserInfo['HomeTel'],
                    'xaddress_phone' => @$mobile,
                    'xaddress_content' => @$gsUserInfo['Address'],
                    'xrank' => 10,
                    'xaddress_title' => 'پیش فرض',
                    'xaddress_name' => @$gsUserInfo['CustomerFName'] . ' ' . @$gsUserInfo['CustomerLName'],
                ]);
            }
        }

        $user->userInfo()->create($userInfo);
        $user->attachRole($role);

        $smsResponse = SMS::send('', $mobile, null, 'wellcome');
        return $user;
    }

    //register user action
    public function signupVerify()
    {
        $enteredOtp = (int) Input::get('code');
        $OTP = (int) Session::get('OTP');

        if ($OTP === $enteredOtp) {
            $mobile = Session::get('mobileNumber');
            $password = Session::get('password');
            //
            $user = $this->createUser($mobile, $password);
            Auth::login($user);

            //Removing Session variable
            Session::forget('OTP');
            Session::forget('mobileNumber');
            Session::forget('password');
            Session::save();

            return response()->json(['success' => true, 'msg' => 'ورود شما را تبریک می گوئیم']);
        } else {
            return response()->json(['success' => false, 'msg' => "کد وارد شده صحیح نمی باشد"], 400);
        }

        return redirect($this->redirectTo ?? '/');
    }

    public function signin()
    {
        if (Auth::id()) {
            return redirect('/');
        }

        $validator = Validator::make(Request::all(), [
            'username' => 'required',
            'password' => 'required',
        ]);

        if ($validator->fails()) {
            if (Request::ajax()) {
                return response()->json(['success' => false, 'message' => $validator->errors(), 'type' => 0], 422);
            }
            return back()
                ->withErrors($validator)
                ->withInput();
        }

        $mobile = Input::get('username');
        $password = Input::get('password');
        $previous = Input::get('previous');

        if (Auth::attempt(['xusername' => $mobile, 'password' => $password], true)) {
            if ($previous)
                return Redirect::to($previous);

            return redirect()->intended('/');
        }
        if (Request::ajax()) {
            return response()->json(['success' => false, 'message' => 'رمز عبور یا کد کاربری صحیح نمی باشد', 'type' => 0], 422);
        }
        return back()
            ->withErrors('رمز عبور یا کد کاربری صحیح نمی باشد')
            ->withInput();
    }

    public function checkUserLogin()
    {
        $user = Auth::user();

        if (!$user) {
            return response()->json(['success' => false, 'message' => 'لطفا در سیستم وارد شوید', 'type' => 0], 401);
        }
        return response()->json(['success' => true, 'message' => 'کاربر در سیستم وارد می باشد', 'type' => 1, 'mobile' => $user->userInfo->xmobile, 'email' => $user->userInfo->xemail]);
    }

    public function signout()
    {
        Auth::logout();
        Session::flush();
        return redirect(property_exists($this, 'redirectAfterLogout') ? $this->redirectAfterLogout : '/');
    }

    public function sendOtp()
    {
        $response = array();
        $mobile = Input::get('mobile');

        if ($mobile == "") {
            return response()->json(['success' => false, 'msg' => 'شماره موبایل صحیح نیست.'], 400);
        } else {
            if (config('app.env') == 'local') {
                $otp = 4444;
                $smsResponse = (object) array('status' => 'successful');
            } else {
                $otp = rand(1000, 9999);
                $smsResponse = SMS::send($otp, $mobile, null, 'sendOtp');
               
            }

            if ($smsResponse->status != 'successful') {
                return response()->json(['success' => false, 'msg' => 'ارسال پیامک با مشکل روبرو شده است. لطفا دوباره تلاش کنید'], 400);
            } else {
                Session::put('OTP', $otp);
                Session::put('mobileNumber', $mobile);
                Session::save();
                return response()->json(['success' => true, 'msg' => 'کد وارد شده با موفقیت ثبت شد']);
            }
        }
        echo json_encode($response);
    }

    public function verifyOtp()
    {

        $response = array();
        $enteredOtp = (int) Input::get('code');
        $OTP = (int) Session::get('OTP');

        if ($OTP === $enteredOtp) {
            // Updating user's status "isVerified" as 1.
            Session::put('resetPassword', 'true');

            //Removing Session variable
            Session::forget('OTP');
            Session::save();

            return response()->json(['success' => true, 'msg' => 'کد وارد شده  با موفقیت ثبت شد']);
        } else {
            return response()->json(['success' => false, 'msg' => "کد وارد شده صحیح نمی باشد"], 400);
        }

        echo json_encode($response);
    }

    public function verifyOtp2()
    {
        $enteredOtp = (int) Input::get('code');
        $mobile = Input::get('mobile');
        $OTP = (int) Session::get('OTP');

        if ($OTP === $enteredOtp) {
            //Removing Session variable
            Session::forget('OTP');
            Session::save();

            $user = User::where('xusername', $mobile)->first();
            if ($user) {
                Auth::guard()->login($user);
            } else {
                $user = $this->createUser($mobile, null);
                Auth::login($user);
            }

        }

        return $this->fetchUser();
    }

    public function fetchUser()
    {
        $user = Auth::user();
        if ($user) 
        {
            $devices = $this->getUserDevices();
            return response()->json(
                [
                    'success' => true,
                    'user' =>
                    [
                        'id' => $user->xuserid,
                        'name' => $user->userInfo->xname . ' ' . $user->userInfo->xfamily,
                        'mobile' => $user->xusername,
                        'devices' => $devices
                    ]
                ]);
        } 
        else
            return response()->json(['success' => false, 'msg' => "کاربر وارد سیستم نشده است"], 400);
    }

    private function getUserDevices(){
        //$profile = new ProfileController();
            //$devices = $profile->getUserDevices($user);
            $devices = [
                [
                    "closedt"=> "1398-06-16",
                    "image_url"=> "/public/goldiran/products/tv.png",
                    "manual"=> "http://gs.goldirancs.ir/datafile_repository/mod_articles/paper/131215-2495/attachments/47la66000-ta.mmdyljk_om-fa.pdf",
                    "model"=> "47LA66000-TA",
                    "productName"=> "تلویزیون 55 اینچ جی‌پلاس",
                    "serial"=> "123456789",
                    "warrantyEndDate"=> "1399-12-01",
                    "priodicEndDate"=> "1399-01-06",
                ],
                [
                    "closedt"=> "1398-06-16",
                    "image_url"=> "/public/goldiran/products/cart.png",
                    "manual"=> "http://gs.goldirancs.ir/datafile_repository/mod_articles/paper/131215-2495/attachments/47la66000-ta.mmdyljk_om-fa.pdf",
                    "model"=> " K312S",
                    "productName"=> "یخچال پایین‌فریزر جی‌پلاس",
                    "serial"=> "123456789",
                    "warrantyEndDate"=> "1404-01-06",
                    "priodicEndDate"=> "1399-10-24",
                ],
                [
                    "closedt"=> "1398-06-16",
                    "image_url"=> "/public/goldiran/products/freez.png",
                    "manual"=> "http://gs.goldirancs.ir/datafile_repository/mod_articles/paper/131215-2495/attachments/47la66000-ta.mmdyljk_om-fa.pdf",
                    "model"=> "4K31266000-A",
                    "productName"=> "ماشین لباسشویی 9 کیلویی جی‌پلاس",
                    "serial"=> "123456789",
                    "warrantyEndDate"=> "1404-01-06",
                    "priodicEndDate"=> "1400-05-06",
                ],
            ];

            return $devices;
    }

    public function changePassword()
    {
        $password = Input::get('password');
        $resetPasswordAllow = Session::get('resetPassword', false);
        $mobile = Session::get('mobileNumber');
        if ($resetPasswordAllow) {
            $user = User::where('xusername', $mobile)->first();
            if ($user) {
                $user->xpassword = Hash::make($password);
                $user->save();
                Auth::guard()->login($user);
                Session::forget('mobileNumber');
                Session::forget('resetPassword');
                Session::save();
                
            } else {
                $user = $this->createUser($mobile, $password);
                Auth::login($user);
            }
            Session::forget('mobileNumber');
            Session::forget('resetPassword');
            Session::save();
            return response()->json(['success' => true, 'msg' => 'رمز عبور با موفقیت تغییر کرد']);
        }
        Session::forget('mobileNumber');
        Session::forget('resetPassword');
        Session::save();
        return response()->json(['success' => false, 'msg' => 'خطا در تغییر رمز عبور. دوباره امتحان کنید'], 400);
    }
}
