<?php namespace Modules\Account\Http\Controllers\Index;

use App\Http\Controllers\IndexController;
use Auth;
use Input;
use Modules\Account\Models\User;
use Modules\Author\Models\Author;
use PDF;
use Redirect;
use Modules\Goldiran\Traits\GS;
use Modules\Home\Traits\Location;

class ProfileController extends IndexController {
    use GS,Location;
    public function index() {
        $user = Auth::user();
        if (!$user) {
            return redirect('/User/login');
        }

        $this->layout->title = trans('profile');
        $this->layout->content = view('account::index.profile.dashboard', ['user' => $user]);
    }

    public function order() {
        $user = Auth::user();
        if (!$user) {
            return redirect('/User/login');
        }

        $invoices = $user->invoices()->orderBy('xinvoice_date', 'desc')->get();
        $this->layout->title = trans('profile');
        $this->layout->content = view('account::index.profile.order', ['invoices' => $invoices]);
    }

    public function orderDetail($id) {
        $user = Auth::user();
        if (!$user) {
            return redirect('/User/login');
        }

        $invoice = $user->invoices()->find($id);
        if (!$invoice) {
            return abort(404);
        }

        $this->layout->title = trans('order detail');
        $this->layout->content = view('account::index.profile.orderDetail', ['invoice' => $invoice, 'user' => $user]);
    }

    public function orderReturn($id) {
        $user = Auth::user();
        if (!$user) {
            return redirect('/User/login');
        }

        $invoice = $user->invoices()->find($id);
        if (!$invoice) {
            return abort(404);
        }

        $this->layout->title = trans('order return');
        $this->layout->content = view('account::index.profile.orderReturn', ['invoice' => $invoice, 'user' => $user]);
    }

    public function storeOrderReturn(){
        $user = Auth::user();
        if (!$user) {
            return redirect('/User/login');
        }
        $returned = Input::get('returned');
        
        $invoice = $user->invoices()->find($returned['invoice']);
        if(!$invoice->returned()->where('product_id',$returned['product'])->exists()){
            $res = $invoice->returned()->create(
            [
                'product_id' => $returned['product'],
                'reason' => $returned['reason'],
                'description' => $returned['desc'],
                'status' => 1
            ]);
        }else{
            return back()->withErrors('سفارش شما از قبل ثبت شده است.');
        }
        
        if ($returned) {
            return back()->with(['success' => 'اطلاعات شما با موفقیت ثبت شد.']);
        }
        return back()->with('error');
    }

    public function addresses() {
        $user = Auth::user();
        if (!$user) {
            return redirect('/User/login');
        }

        $addresses = $user->address;
        $location = self::getZones();

        $this->layout->title = trans('profile');
        $this->layout->content = view('account::index.profile.address', array_merge(['addresses' => $addresses],$location));
    }

    public function updateAddress() {
        $data = Input::get('data');
        if (!@$data['mobile'] or !@$data['address'] or !@$data['title']) {
            return response()->json(['success' => false, 'msg' => 'وارد کردن اطلاعات فیلدها ضروری است'], 404);
        }
        $user = Auth::user();
        if ($user) {
            if ($data['id']) {
                $address = $user->address()->find($data['id']);
                $address->xaddress_title = @$data['title'] ?: 'عنوان جدید';
                $address->xaddress_phone = $data['mobile'];
                $address->xaddress_content = $data['address'];
                $address->xaddress_name = $data['name'];
                $address->xprovinceid = $data['province'];
                $address->xcityid = @$data['city'];
                $address->xregionid = @$data['region'];
                $address->xparishid = @$data['parish'];
                $address->xaddress_postal_code = $data['postalCode'];
                $address->save();

            } else {
                $address = $user->address()->create([
                    'xaddress_title' => @$data['title'] ?: 'عنوان جدید',
                    'xaddress_phone' => $data['mobile'],
                    'xaddress_content' => $data['address'],
                    'xaddress_name' => $data['name'],
                    'xprovinceid' => $data['province'],
                    'xcityid' => @$data['city'],
                    'xregionid' => @$data['region'],
                    'xparishid' => @$data['parish'],
                    'xaddress_postal_code' => $data['postalCode'],
                ]);
            }

            return response()->json([
                'id' => $address->xaddressid,
                'title' => $address->xaddress_title,
                'mobile' => $address->xaddress_phone,
                'address' => $address->xaddress_content,
            ]);

        }
        return response()->json(['success' => false, 'msg' => 'خطا در برقراری ارتباط'], 404);
    }

    public function removeAddress() {
        $id = Input::get('id');
        $user = Auth::user();

        if ($user) {
            $user->address()->find($id)->delete();
            response()->json(['success' => true]);
        }
        response()->json(['success' => false, 'msg' => 'خطا در برقراری ارتباط'], 404);
    }

    public function comments() {
        $user = Auth::user();
        if (!$user) {
            return redirect('/User/login');
        }

        $comments = $user->comments;

        $this->layout->title = trans('profile');
        $this->layout->content = view('account::index.profile.comments', ['comments' => $comments]);
    }

    public function updateComment() {
        $data = Input::get('data');
        if (!@$data['comment'] or !@$data['id']) {
            return response()->json(['success' => false, 'msg' => 'وارد کردن اطلاعات فیلدها ضروری است'], 404);
        }
        $user = Auth::user();
        if ($user) {

            try {
                $comment = $user->comments()->find($data['id']);
                $comment->xcomment_content = $data['comment'];
                $comment->save();

            } catch (Exception $e) {
                return response()->json(['success' => false, 'msg' => 'خطا در برقراری ارتباط'], 404);
            }

            return response()->json([
                'id' => $comment->xcommentid,
                'comment' => $comment->xcomment_content,
            ]);

        }
        return response()->json(['success' => false, 'msg' => 'خطا در برقراری ارتباط'], 404);
    }

    public function removeComment() {
        $id = Input::get('id');
        $user = Auth::user();

        if ($user) {
            try {
                $user->comments()->find($id)->delete();
                return response()->json(['success' => true]);
            } catch (Exception $e) {
                return response()->json(['success' => false, 'msg' => 'خطا در برقراری ارتباط'], 404);
            }
        }
        return response()->json(['success' => false, 'msg' => 'خطا در برقراری ارتباط'], 404);
    }

    public function additionalInfo() {
        $user = Auth::user();
        if (!$user) {
            return redirect('/User/login');
        }

        $this->layout->title = trans('profile');
        $this->layout->content = view('account::index.profile.addInfo', ['user' => $user]);
    }

    public function storeAdditionalInfo() {
        $user = Auth::user();
        if (!$user) {
            return redirect('/User/login');
        }

        $addinfo = Input::get('additionalinfo');
        if ($addinfo) {
            $user->userInfo->xname = $addinfo['first_name'];
            $user->userInfo->xfamily = $addinfo['last_name'];
            $user->userInfo->xemail = $addinfo['email'];
            $user->userInfo->xintcode = $user->userInfo->xintcode ?? $addinfo['intcode'];
            //$user->userInfo->xbirthday = $addinfo['brithday'];
            //$user->userInfo->xmobile = $addinfo['mobile'];
            $user->userInfo->save();
            $user->save();

            return back()->with(['success' => 'اطلاعات شما با موفقیت ثبت شد.']);
        }
        return back()->with('error');
    }

    public function messages() {
        $user = Auth::user();
        if (!$user) {
            return redirect('/User/login');
        }

        $messages = $user->messages;

        $this->layout->title = trans('profile');
        $this->layout->content = view('account::index.profile.message', ['messages' => $messages]);
    }

    public function favorites() {
        $user = Auth::user();
        if (!$user) {
            return redirect('/User/login');
        }

        $favorites = $user->favorites;

        $this->layout->title = trans('profile');
        $this->layout->content = view('account::index.profile.favorites', ['favorites' => $favorites]);
    }

    public function myDevice() {
        $user = Auth::user();
        if (!$user) {
            return redirect('/User/login');
        }
        $devices = $this->getUserDevices();
        $this->layout->title = trans('my devices');
        $this->layout->content = view('account::index.profile.mydevices', ['devices' => (array)$devices]);
    }

    public function getUserDevices(){
        $user = Auth::user();
        if(!$user) return null;
        $devices = [];
        if($user->userInfo->xmobile){
            $devices = (array)$this->gsProductByMobile($user->userInfo->xmobile);
            $devices = array_key_exists('product',$devices) ? $devices['product'] : $devices;
            
            foreach ($devices as $key => $value) {
                $manual = $this->gsGetManual($value->model);
                $value->manual = ($manual && $manual->model) ? $manual->model->filepath : null;
                $devices[$key] = (array)$value;
                $devices[$key]['image_url'] = '/public/goldiran/products/tv.png';
            }
        }

        return $devices;
    }
    public function myService() {
        $user = Auth::user();
        if (!$user) {
            return redirect('/User/login');
        }

        $services = [];
        if($user->userInfo->xmobile)
            $services = $this->gsServiceByMobile($user->userInfo->xmobile);

        $this->layout->title = trans('my services');
        $this->layout->content = view('account::index.profile.myservices', ['services' => (array)$services]);
    }

    public function removeFavorite() {
        $id = Input::get('id');
        $user = Auth::user();

        if ($user) {
            try {
                $user->favorites()->detach($id);
                return response()->json(['success' => true]);
            } catch (Exception $e) {
                return response()->json(['success' => false, 'msg' => 'خطا در برقراری ارتباط'], 404);
            }
        }
        return response()->json(['success' => false, 'msg' => 'خطا در برقراری ارتباط'], 404);
    }

    public function updateFavorite() {
        $id = Input::get('id');
        $type = Input::get('type');
        $user = Auth::user();
        
        if(!$user){
            return response()->json(['success' => false, 'message' => 'لطفا در سیستم وارد شوید', 'type' => 0],401); 
        }

        if ($user) {
            try {
                $user->favorites()->toggle($id);
                return response()->json(['success' => true]);
            } catch (Exception $e) {
                return response()->json(['success' => false, 'msg' => 'خطا در برقراری ارتباط'], 404);
            }
        }
        return response()->json(array(
            'status' => 'failed',
            'code' => 404,
            'message' => 'جهت درج در علاقه مندی ها ابتدا وارد سیستم شوید.',
        ), 404);
    }

    public function downloadInvoicePdf($id) {
        $user = Auth::user();
        if (!$user) {
            return redirect('/User/login');
        }

        $invoice = $user->invoices()->find($id);

        if ($invoice && $invoice->xinvoice_status == 'onlinepaymentfinal') {
            $pdf = PDF::loadView('cart::pdf.invoice', ['invoices' => [0 => $invoice]])->setRtl();
            return $pdf->download("invoice{$invoice->xinvoice_number}.pdf");
        } else {
            return back();
        }

    }

    public function authorBooks() {
        $user = Auth::user();
        if (!$user) {
            return redirect('/User/login');
        }

        if (!$user->xrelation_oneid) {
            return redirect('/Profile');
        }

        $authorid = $user->xrelation_oneid;
        $books = Author::find($authorid)->books;

        $this->layout->title = trans('book');
        $this->layout->content = view('account::index.profile.authorBooks', ['book' => $books]);
    }

}
