<?php

namespace Modules\Account\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use Auth;
use Config;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Http\Request;
use Log;
use Modules\Account\Models\User;
use Session;
use Response;

class LoginController extends Controller {
    /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
     */

    use AuthenticatesUsers;

    /**
     * Where to redirect users after login.
     *
     * @var string
     */
    protected $redirectTo = '/home';

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct() {
        Config::set('app.controller', 'auth');
        $this->middleware('guest')->except(['logout','fetchUser']);
    }

    public function login(Request $request) {
        $loginType = $request->get('loginType');
        $fld = ($loginType == 'withEmail' ? 'email' : 'username');
        $fldDatabase = ($loginType == 'withEmail' ? 'email' : 'xusername');

        $rules = [
            $fld => 'required',
            'password' => 'required',
            'captcha' => 'required|captcha',
        ];

        $this->validate($request, $rules);

        if (User::whereRaw("LOWER({$fldDatabase}) = '" . $request->get($fld) . "' AND xuser_status = 'inactive'")->first()) {
            $msg = trans('language.your user account is under reviewing for final confirmation');
            if ($request->expectsJson()) {
                return Response::json(['type' => 'error', 'message' => $msg], 422);
            } else {
                return back()
                    ->withInput($request->only($fld, 'remember'))
                    ->withErrors($msg);
            }
        }

        $credentials = [
            $fldDatabase => $request->get($fld),
            'password' => $request->get('password'),
            'xuser_status' => 'active',
        ];

        if (Auth::attempt($credentials, $request->has('remember'))) {

            $this->group = array_flip(Auth::user()->roles()->pluck('xxsecurity_role.xroleid', 'xname')->toArray());
            if (Auth::user()->xuser_type) {
                $this->group = [Auth::user()->xuser_type => true];
            }

            $groups = array_values($this->group);

            if ($this->group) {
                if ($request->expectsJson()) {
                    return Response::json(['user' => Auth::user() ]);
                }
                return redirect()->intended(studly_case($groups[0]));
            } else {
                Auth::logout();
                $msg = trans('language.user group is not defined!');
                if ($request->expectsJson()) {
                    return Response::json(['type' => 'error', 'message' => $msg], 422);
                } else {
                    return back()
                        ->withInput($request->only($fld, 'remember'))
                        ->withErrors($msg);
                }
            }

        }

        $msg = trans('language.These credentials do not match our records.');
        if ($request->expectsJson()) {
            return Response::json(['type' => 'error', 'message' => $msg], 422);
        }
        return back()
            ->withInput($request->only($fld, 'remember'))
            ->withErrors([
                $fld => $msg,
            ]);
    }

    public function username() {
        return 'xusername';
    }

    public function showLoginForm() {
        return view('account::admin.auth.login');
    }

    public function fetchUser(Request $request){
        if(Auth::check()){
            if ($request->expectsJson()) {
                return Response::json(['user' => Auth::user() ]);
            }
            return redirect('/');
        }
        return Response::json(['type' => 'error', 'message' => 'user not logging']);
    }

    /**
     * Logout, Clear Session, and Return.
     *
     * @return void
     */
    public function logout() {
        $user = Auth::user();
        Log::info('User Logged Out. ', [$user]);
        Auth::logout();
        Session::flush();
        return redirect(property_exists($this, 'redirectAfterLogout') ? $this->redirectAfterLogout : '/');
    }
}
