<?php namespace Modules\Account\Http\Controllers\Api;

use App\Http\Controllers\ApiController;
use Auth;
use File;
use Illuminate\Support\Carbon;
use Input;
use Modules\Account\Exception\ApiException;
use Modules\Account\Models\Session;
use Modules\Account\Models\User;
use Modules\Book\Models\Book;
use Modules\Book\Models\BookCode;
use Modules\Book\Models\BookAdvertise;
use Modules\Home\Models\Banner;
use Modules\Home\Models\Config;

class UserController extends ApiController {

    public function getBaseUrl() {
        $config = Config::where('xtype', 'version')->getWithLocale()->first();
        $config = json_decode($config->xconfig_data, true);
        //$baseLink = Request::getHost();
        $baseLink = "http://digital.cppc.ir";
        //$baseLink = "http://192.168.209.2";
        $banners = Banner::where('xstatus', '1')->getWithLocale();
        $bannerArray = [];
        foreach ($banners as $key => $value) {
            $bannerArray[] = [
                "slide_id" => $value->xbannerid,
                "picLink" => $baseLink . "/pic/banner.image/{$value->xbannerid}/w850h360c1.jpg",
                "type" => 1,
                "Parameter" => $value->xbanner_link,
            ];
        }

        $data = [
            "version" => $config['mobile']['version'],
            "Topics_Url" => $baseLink . "/Rss/list",
            "Download_Url" => $baseLink . "/mobile",
            "Download_Url" => $baseLink . "/download",
            "BookList_Zip" => $baseLink . "/api/BookListFiles/bookfile_1.zip?v=" . $config['mobile']['version'],
            "Logo" => $baseLink . "/images/logo.png",
            "FlatImage_1" => $baseLink . "/api/pic/book/w240h320",
            "FlatImage_2" => $baseLink . "/api/pic/book/w480h640",
            "donate" => [
                "Active" => [
                    "ios" => 1,
                    "android" => 1,
                    "winphone" => 1,
                    "windows" => 1,
                ],
                "Links" => [
                    "shetab" => $baseLink . "/Donate",
                    "paypal" => "https://www.paypal.me/SNabavi",
                ],
                "Description" => "",
            ],
            "AndroidUrl" => $baseLink . "/Software/cppc.apk",
            "AndroidVer" => $config['mobile']['version'],
            "Slides_private" => $bannerArray,
            "Slides_public" => [],
            "Servers" => [
                "site" => $baseLink,
                "download" => $baseLink . "/download",
                "new_site" => $baseLink,
                "new_download" => $baseLink . "/download",
            ],
            "buyPrintUrl" => $baseLink . "/api/buyprint",
            "getDigitalUrl" => $baseLink . "/api/getDigitalBook",
            "buyHistory" => $baseLink . "/api/buyhistory",
            "bookAdvertise" => $baseLink . "/api/bookAdvertise",

        ];
        return response()->json($data);
    }

    public function bookZipFile() {
        $version = Input::get('v');
        $path = public_path() . "/mobile/version/v{$version}.zip";
        return response()->download($path);
    }

    public function bookInfo() {

        $desc = Input::get('desc', 0);
        $id = Input::get('id', 0);

        //get session
        $session = Input::get('session');
        if ($session) {
            $dbSession = Session::where('xuuid', $session)->first();
            if ($dbSession) {
                $user = User::find($dbSession->xuserid);
            }
        }

        //book
        $book = Book::find($id);
        if (!$book) {
            return response()->json(["msg" => "کتاب مورد نظر یافت نشد"]);
        }
        $bookPath = str_finish(storage_path('app/secure'), '/') . 'Book/digitalBook/' . $book->xbookid;
        $bookSize = 0;

        if (File::exists($bookPath)) {
            $bookSize = filesize($bookPath);
        }

        $data = [
            "id" => "{$book->xbookid}",
            "title" => $book->xbook_title,
            "author" => $book->author ? $book->author->implode('xauthor_name', ' ,') : "",
            "main_subject_id" => "{$book->category->xsubcategoryid}",
            "main_subject_name_fa" => $book->category->xsubcategory_name,
            "main_subject_name_ar" => "",
            "main_subject_name_en" => "",
            "subject_1" => "-1",
            "subject_2" => "-1",
            "year" => "{$book->xbook_year}",
            "ghm_file_name" => $book->xbook_title . ".ghm",
            "pic_name" => $book->xbookid . ".png",
            "download_count" => "1998",
            "file_size" => "{$bookSize}",
            "price" => "{$book->xbook_digital_price}",
            "publish" => $book->xbook_publish,
            "book_desc" => strip_tags($book->xbook_abstract),
            "publisher_id" => $book->publisher ? $book->publisher->xpublisherid : "",
            "publisher_name" => $book->publisher ? $book->publisher->xpublisher_name : "",
            "source" => $book->publisher ? $book->publisher->xpublisher_name : "",
            "version" => "1",
            "Rate" => "4.4615",
            "RateCount" => "13",
            "jeld_num" => "1",
            "jeld_count" => "1",
            "totalpages" => "{$book->xbook_pages}",
            "jeld_koli" => "0",
            "lang" => "فارسي",
            "type" => "کتاب",
            "isBuyed" => true,
        ];

        return response()->json($data);
    }

    public function buyPrint() {
        $bookid = Input::get('id');
        $session = Input::get('session');
        if ($session) {
            $dbSession = Session::where('xuuid', $session)->first();
            if ($dbSession) {
                $user = User::find($dbSession->xuserid);
                if (Auth::check()) {
                    if ($user) {
                        if (Auth::id() != $user->xuserid) {
                            // The user is logged in and not user that registered with mobile
                            Auth::logout();
                            Auth::login($user);
                        }
                    } else {
                        Auth::logout();
                    }
                } else {
                    //user not logged
                    if ($user) {
                        Auth::login($user);
                    }
                }
            }
        }
    }

    public function getDigitalBook() {
        $bookid = Input::get('id');
        $session = Input::get('session');
        if ($session) {
            $dbSession = Session::where('xuuid', $session)->first();
            if ($dbSession) {
                $user = User::find($dbSession->xuserid);
                if (!$user) {
                    return response()->json(["msg" => "کاربر مورد نظر یافت نشد"]);
                }
                $isBookBoughted = $this->isUserBoughtedDigitalBook($user, $bookid);

                $baseLink = "http://digital.cppc.ir";
                //$baseLink = "http://192.168.209.2";
                if ($isBookBoughted) {
                    return response()->json([
                        'id' => $bookid,
                        'session' => $session,
                        'state' => '1',
                        'message' => 'book boughted',
                        'url' => $baseLink . "/api/downloadBook?id=$bookid&session=$session",
                    ]);

                } else {
                    return response()->json([
                        'id' => $bookid,
                        'session' => $session,
                        'state' => '2',
                        'message' => 'book not boughted',
                        'url' => $baseLink . "/Payment/digitalindex?id=$bookid&session=$session",
                    ]);
                }
            } else {
                return response()->json(["msg" => "کاربر مورد نظر یافت نشد"]);
            }
        }
    }

    public function downloadBook() {
        $bookid = Input::get('id');
        $session = Input::get('session');
        if ($session) {
            $dbSession = Session::where('xuuid', $session)->first();
            if ($dbSession) {
                $user = User::find($dbSession->xuserid);
                if (!$user) {
                    return response()->json(["msg" => "کاربر مورد نظر یافت نشد"]);
                }
                $isBookBoughted = $this->isUserBoughtedDigitalBook($user, $bookid);

                $baseLink = "http://digital.cppc.ir";
                //$baseLink = "http://192.168.209.2";
                if ($isBookBoughted) {
                    $bookPath = str_finish(storage_path('app/secure'), '/') . 'Book/digitalBook/' . $bookid;

                    if (File::exists($bookPath)) {
                        return response()->download($bookPath);
                    } else {
                        return response()->json([
                            'id' => $bookid,
                            'session' => $session,
                            'state' => '0',
                            'message' => 'digital book not find',
                        ]);
                    }
                } else {
                    return response()->json([
                        'id' => $bookid,
                        'session' => $session,
                        'state' => '2',
                        'message' => 'book not boughted',
                        'url' => $baseLink . "/Payment/digitalindex?id=$bookid&session=$session",
                    ]);
                }
            } else {
                return response()->json(["msg" => "کاربر مورد نظر یافت نشد"]);
            }
        }
    }

    private function isUserBoughtedDigitalBook($user, $bookid) {
        $isBookBoughted = false;
        if((int)$bookid == 1221){
            $isBookBoughted = BookCode::where('xbookid',1221)->where('xuserid',$user->xuserid)->count();
        }else if((int)$bookid == 1297){
            $isBookBoughted = BookCode::where('xbookid',1297)->where('xuserid',$user->xuserid)->count();
        }else{
            foreach ($user->invoices()->where('xinvoice_status', 'onlinepaymentfinal')->with('items')->get() as $invoice) {

                $isBookBoughted = $invoice->items()->where('xbookid', (int) $bookid)->count();
    
                if ($isBookBoughted) {
                    break;
                }
            }
        }

        return $isBookBoughted;
    }

    public function buyHistory() {}

    public function bookAdvertise() {
        try {
            $bookid = Input::get('id');
            if (!$bookid) {
                throw new ApiException(null, 1);
            }

            $adv = bookAdvertise::where('xbookid', $bookid)->where('xstatus', 1)->orderBy('xrank', 'desc')->first();
            if (!$adv || !$adv->xcontent || $adv->xstart > Carbon::now() || $adv->xend < Carbon::now()) {
                throw new ApiException(null, 1);
            }

            return "<html><head></head><body>" . str_replace('src="/', 'src="http://digital.cppc.ir/', $adv->xcontent) . "</body></html>";
        } catch (ApiException $e) {
            $e->errorMessage();
        }
    }
}
